/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLNameBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Map;

public class CSLName
implements JsonObject {
    private final String family;
    private final String given;
    private final String droppingParticle;
    private final String nonDroppingParticle;
    private final String suffix;
    private final Boolean commaPrefix;
    private final Boolean commaSuffix;
    private final Boolean staticOrdering;
    private final String literal;
    private final Boolean parseNames;

    public CSLName() {
        this.family = null;
        this.given = null;
        this.droppingParticle = null;
        this.nonDroppingParticle = null;
        this.suffix = null;
        this.commaPrefix = null;
        this.commaSuffix = null;
        this.staticOrdering = null;
        this.literal = null;
        this.parseNames = null;
    }

    public CSLName(String family, String given, String droppingParticle, String nonDroppingParticle, String suffix, Boolean commaPrefix, Boolean commaSuffix, Boolean staticOrdering, String literal, Boolean parseNames) {
        this.family = family;
        this.given = given;
        this.droppingParticle = droppingParticle;
        this.nonDroppingParticle = nonDroppingParticle;
        this.suffix = suffix;
        this.commaPrefix = commaPrefix;
        this.commaSuffix = commaSuffix;
        this.staticOrdering = staticOrdering;
        this.literal = literal;
        this.parseNames = parseNames;
    }

    public String getFamily() {
        return this.family;
    }

    public String getGiven() {
        return this.given;
    }

    public String getDroppingParticle() {
        return this.droppingParticle;
    }

    public String getNonDroppingParticle() {
        return this.nonDroppingParticle;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Boolean getCommaPrefix() {
        return this.commaPrefix;
    }

    public Boolean getCommaSuffix() {
        return this.commaSuffix;
    }

    public Boolean getStaticOrdering() {
        return this.staticOrdering;
    }

    public String getLiteral() {
        return this.literal;
    }

    public Boolean getParseNames() {
        return this.parseNames;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        if (this.family != null) {
            builder.add("family", this.family);
        }
        if (this.given != null) {
            builder.add("given", this.given);
        }
        if (this.droppingParticle != null) {
            builder.add("dropping-particle", this.droppingParticle);
        }
        if (this.nonDroppingParticle != null) {
            builder.add("non-dropping-particle", this.nonDroppingParticle);
        }
        if (this.suffix != null) {
            builder.add("suffix", this.suffix);
        }
        if (this.commaPrefix != null) {
            builder.add("comma-prefix", this.commaPrefix);
        }
        if (this.commaSuffix != null) {
            builder.add("comma-suffix", this.commaSuffix);
        }
        if (this.staticOrdering != null) {
            builder.add("static-ordering", this.staticOrdering);
        }
        if (this.literal != null) {
            builder.add("literal", this.literal);
        }
        if (this.parseNames != null) {
            builder.add("parse-names", this.parseNames);
        }
        return builder.build();
    }

    public static CSLName fromJson(Map<String, Object> obj) {
        Map vc;
        Object vcmain;
        CSLNameBuilder builder = new CSLNameBuilder();
        Object v = obj.get("family");
        if (v != null) {
            String family = v.toString();
            builder.family(family);
        }
        if ((v = obj.get("given")) != null) {
            String given = v.toString();
            builder.given(given);
        }
        if ((v = obj.get("dropping-particle")) != null) {
            String droppingParticle = v.toString();
            builder.droppingParticle(droppingParticle);
        }
        if ((v = obj.get("non-dropping-particle")) != null) {
            String nonDroppingParticle = v.toString();
            builder.nonDroppingParticle(nonDroppingParticle);
        }
        if ((v = obj.get("suffix")) != null) {
            String suffix = v.toString();
            builder.suffix(suffix);
        }
        if ((v = obj.get("comma-prefix")) != null) {
            Boolean commaPrefix = CSLName.toBool(v);
            builder.commaPrefix(commaPrefix);
        }
        if ((v = obj.get("comma-suffix")) != null) {
            Boolean commaSuffix = CSLName.toBool(v);
            builder.commaSuffix(commaSuffix);
        }
        if ((v = obj.get("static-ordering")) != null) {
            Boolean staticOrdering = CSLName.toBool(v);
            builder.staticOrdering(staticOrdering);
        }
        if ((v = obj.get("literal")) != null) {
            String literal = v.toString();
            builder.literal(literal);
        }
        if ((v = obj.get("parse-names")) != null) {
            Boolean parseNames = CSLName.toBool(v);
            builder.parseNames(parseNames);
        }
        if ((v = obj.get("multi")) != null && v instanceof Map && (vcmain = (vc = (Map)v).get("main")) != null && vcmain instanceof String) {
            String mstr = (String)vcmain;
            if ((mstr = mstr.toLowerCase().substring(0, 2)).equals("hu") || mstr.equals("vn")) {
                builder.staticOrdering(true);
            }
        }
        return builder.build();
    }

    private static int toInt(Object o) {
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }
}

