/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitationItemBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLLabel;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Collection;
import java.util.Map;

public class CSLCitationItem
implements JsonObject {
    private final String id;
    private final CSLItemData itemData;
    private final String prefix;
    private final String suffix;
    private final String locator;
    private final Integer position;
    private final Boolean nearNote;
    private final Integer noteNumber;
    private final Integer firstReferenceNoteNumber;
    private final CSLLabel label;
    private final Boolean suppressAuthor;
    private final Boolean authorOnly;
    private final String[] uris;

    public CSLCitationItem(String id) {
        this.id = id;
        this.itemData = null;
        this.prefix = null;
        this.suffix = null;
        this.locator = null;
        this.position = null;
        this.nearNote = null;
        this.noteNumber = null;
        this.firstReferenceNoteNumber = null;
        this.label = null;
        this.suppressAuthor = null;
        this.authorOnly = null;
        this.uris = null;
    }

    public CSLCitationItem(String id, CSLItemData itemData, String prefix, String suffix, String locator, Integer position, Boolean nearNote, Integer noteNumber, Integer firstReferenceNoteNumber, CSLLabel label, Boolean suppressAuthor, Boolean authorOnly, String[] uris) {
        this.id = id;
        this.itemData = itemData;
        this.prefix = prefix;
        this.suffix = suffix;
        this.locator = locator;
        this.position = position;
        this.nearNote = nearNote;
        this.noteNumber = noteNumber;
        this.firstReferenceNoteNumber = firstReferenceNoteNumber;
        this.label = label;
        this.suppressAuthor = suppressAuthor;
        this.authorOnly = authorOnly;
        this.uris = uris;
    }

    public String getId() {
        return this.id;
    }

    public CSLItemData getItemData() {
        return this.itemData;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getLocator() {
        return this.locator;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Boolean getNearNote() {
        return this.nearNote;
    }

    public Integer getNoteNumber() {
        return this.noteNumber;
    }

    public Integer getFirstReferenceNoteNumber() {
        return this.firstReferenceNoteNumber;
    }

    public CSLLabel getLabel() {
        return this.label;
    }

    public Boolean getSuppressAuthor() {
        return this.suppressAuthor;
    }

    public Boolean getAuthorOnly() {
        return this.authorOnly;
    }

    public String[] getUris() {
        return this.uris;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        builder.add("id", this.id);
        if (this.itemData != null) {
            builder.add("itemData", this.itemData);
        }
        if (this.prefix != null) {
            builder.add("prefix", this.prefix);
        }
        if (this.suffix != null) {
            builder.add("suffix", this.suffix);
        }
        if (this.locator != null) {
            builder.add("locator", this.locator);
        }
        if (this.position != null) {
            builder.add("position", this.position);
        }
        if (this.nearNote != null) {
            builder.add("near-note", this.nearNote);
        }
        if (this.noteNumber != null) {
            builder.add("note-number", this.noteNumber);
        }
        if (this.firstReferenceNoteNumber != null) {
            builder.add("first-reference-note-number", this.firstReferenceNoteNumber);
        }
        if (this.label != null) {
            builder.add("label", (Object)this.label);
        }
        if (this.suppressAuthor != null) {
            builder.add("suppress-author", this.suppressAuthor);
        }
        if (this.authorOnly != null) {
            builder.add("author-only", this.authorOnly);
        }
        if (this.uris != null) {
            builder.add("uris", this.uris);
        }
        return builder.build();
    }

    public static CSLCitationItem fromJson(Map<String, Object> obj) {
        Object v = obj.get("id");
        if (v == null) {
            throw new IllegalArgumentException("Missing property `id'");
        }
        String id = v.toString();
        CSLCitationItemBuilder builder = new CSLCitationItemBuilder(id);
        Object v2 = obj.get("itemData");
        if (v2 != null) {
            if (!(v2 instanceof Map)) {
                throw new IllegalArgumentException("`itemData' must be an object");
            }
            CSLItemData itemData = CSLItemData.fromJson((Map)v2);
            builder.itemData(itemData);
        }
        if ((v2 = obj.get("prefix")) != null) {
            String prefix = v2.toString();
            builder.prefix(prefix);
        }
        if ((v2 = obj.get("suffix")) != null) {
            String suffix = v2.toString();
            builder.suffix(suffix);
        }
        if ((v2 = obj.get("locator")) != null) {
            String locator = v2.toString();
            builder.locator(locator);
        }
        if ((v2 = obj.get("position")) != null) {
            Integer position = CSLCitationItem.toInt(v2);
            builder.position(position);
        }
        if ((v2 = obj.get("near-note")) != null) {
            Boolean nearNote = CSLCitationItem.toBool(v2);
            builder.nearNote(nearNote);
        }
        if ((v2 = obj.get("note-number")) != null) {
            Integer noteNumber = CSLCitationItem.toInt(v2);
            builder.noteNumber(noteNumber);
        }
        if ((v2 = obj.get("first-reference-note-number")) != null) {
            Integer firstReferenceNoteNumber = CSLCitationItem.toInt(v2);
            builder.firstReferenceNoteNumber(firstReferenceNoteNumber);
        }
        if ((v2 = obj.get("label")) != null) {
            CSLLabel label = CSLLabel.fromString(v2.toString());
            builder.label(label);
        }
        if ((v2 = obj.get("suppress-author")) != null) {
            Boolean suppressAuthor = CSLCitationItem.toBool(v2);
            builder.suppressAuthor(suppressAuthor);
        }
        if ((v2 = obj.get("author-only")) != null) {
            Boolean authorOnly = CSLCitationItem.toBool(v2);
            builder.authorOnly(authorOnly);
        }
        if ((v2 = obj.get("uris")) != null) {
            if (!(v2 instanceof Collection)) {
                throw new IllegalArgumentException("`uris' must be an array");
            }
            Collection cv = (Collection)v2;
            String[] uris = new String[cv.size()];
            int i = 0;
            for (Object vo : cv) {
                uris[i] = vo.toString();
                ++i;
            }
            builder.uris(uris);
        }
        return builder.build();
    }

    private static int toInt(Object o) {
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }
}

