/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitationBuilder;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLProperties;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Collection;
import java.util.Map;

public class CSLCitation
implements JsonObject {
    private final CSLCitationItem[] citationItems;
    private final String citationID;
    private final CSLProperties properties;

    public CSLCitation(CSLCitationItem ... citationItems) {
        this.citationItems = citationItems;
        this.citationID = Long.toString((long)Math.floor(Math.random() * 1.0E14), 32);
        this.properties = new CSLProperties();
    }

    public CSLCitation(CSLCitationItem[] citationItems, String citationID, CSLProperties properties) {
        this.citationItems = citationItems;
        this.citationID = citationID;
        this.properties = properties;
    }

    public CSLCitationItem[] getCitationItems() {
        return this.citationItems;
    }

    public String getCitationID() {
        return this.citationID;
    }

    public CSLProperties getProperties() {
        return this.properties;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        builder.add("citationItems", this.citationItems);
        if (this.citationID != null) {
            builder.add("citationID", this.citationID);
        }
        if (this.properties != null) {
            builder.add("properties", this.properties);
        }
        return builder.build();
    }

    public static CSLCitation fromJson(Map<String, Object> obj) {
        Object v = obj.get("citationItems");
        if (v == null) {
            throw new IllegalArgumentException("Missing property `citationItems'");
        }
        if (!(v instanceof Collection)) {
            throw new IllegalArgumentException("`citationItems' must be an array");
        }
        Collection cv = (Collection)v;
        CSLCitationItem[] citationItems = new CSLCitationItem[cv.size()];
        int i = 0;
        for (Object vo : cv) {
            if (!(vo instanceof Map)) {
                throw new IllegalArgumentException("`citationItems' must be an array of objects");
            }
            citationItems[i] = CSLCitationItem.fromJson((Map)vo);
            ++i;
        }
        CSLCitationBuilder builder = new CSLCitationBuilder(citationItems);
        Object v2 = obj.get("citationID");
        if (v2 != null) {
            String citationID = v2.toString();
            builder.citationID(citationID);
        } else {
            builder.citationID(Long.toString((long)Math.floor(Math.random() * 1.0E14), 32));
        }
        v2 = obj.get("properties");
        if (v2 != null) {
            if (!(v2 instanceof Map)) {
                throw new IllegalArgumentException("`properties' must be an object");
            }
            CSLProperties properties = CSLProperties.fromJson((Map)v2);
            builder.properties(properties);
        } else {
            builder.properties(new CSLProperties());
        }
        return builder.build();
    }

    private static int toInt(Object o) {
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }
}

