/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.bibtex.BibTeXItemDataProvider;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.helper.Levenshtein;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.json.StringJsonBuilderFactory;
import de.undercouch.citeproc.helper.oauth.FileAuthenticationStore;
import de.undercouch.citeproc.helper.oauth.RequestException;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import de.undercouch.citeproc.helper.tool.Option;
import de.undercouch.citeproc.helper.tool.OptionBuilder;
import de.undercouch.citeproc.helper.tool.OptionGroup;
import de.undercouch.citeproc.helper.tool.OptionParser;
import de.undercouch.citeproc.helper.tool.OptionParserException;
import de.undercouch.citeproc.helper.tool.Value;
import de.undercouch.citeproc.helper.tool.internal.CachingMendeleyConnector;
import de.undercouch.citeproc.mendeley.AuthenticatedMendeleyConnector;
import de.undercouch.citeproc.mendeley.DefaultMendeleyConnector;
import de.undercouch.citeproc.mendeley.MendeleyConnector;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.Citation;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.ParseException;

public class CSLTool {
    private static OptionGroup<OID> options = new OptionBuilder<OID>().add(OID.BIBLIOGRAPHY, "bibliography", "b", "input bibliography FILE (*.bib, *.json)", "FILE", Option.ArgumentType.STRING).add(OID.STYLE, "style", "s", "citation STYLE name (default: ieee)", "STYLE", Option.ArgumentType.STRING).add(OID.LOCALE, "locale", "l", "citation LOCALE (default: en-US)", "LOCALE", Option.ArgumentType.STRING).add(OID.FORMAT, "format", "f", "output format: text (default), html, asciidoc, fo, rtf", "FORMAT", Option.ArgumentType.STRING).add(OID.CITATION, "citation", "c", "generate citations and not a bibliography").add(OID.LIST, "list", "display sorted list of available citation IDs").add(new OptionBuilder<OID>("Mendeley:").add(OID.MENDELEY, "mendeley", "read input bibliography from Mendeley Web").add(OID.MENDELEY_SYNC, "mendeley-sync", "synchronize with Mendeley Web, implies --mendeley").build()).add(new OptionBuilder<OID>("Miscellaneous:").add(OID.HELP, "help", "h", "display this help and exit").add(OID.VERSION, "version", "V", "output version information and exit").build()).build();
    private File configDir;

    public static void main(String[] args) throws IOException {
        CSLTool tool = new CSLTool();
        int exitCode = tool.run(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public int run(String[] args) throws IOException {
        List<Value<OID>> values;
        this.configDir = new File(System.getProperty("user.home"), ".citeproc-java");
        this.configDir.mkdirs();
        try {
            values = OptionParser.parse(args, options, OID.CITATIONID);
        }
        catch (OptionParserException e) {
            System.err.println("citeproc-java: " + e.getMessage());
            return 1;
        }
        if (values.isEmpty()) {
            this.usage();
            return 0;
        }
        String bibliography = null;
        boolean mendeley = false;
        boolean mendeleySync = false;
        String style = "ieee";
        String locale = "en-US";
        String format = "text";
        boolean citation = false;
        boolean list = false;
        ArrayList<String> citationIds = new ArrayList<String>();
        for (Value<OID> v : values) {
            switch (v.getId()) {
                case BIBLIOGRAPHY: {
                    bibliography = v.getValue().toString();
                    break;
                }
                case MENDELEY: {
                    mendeley = true;
                    break;
                }
                case MENDELEY_SYNC: {
                    mendeley = true;
                    mendeleySync = true;
                    break;
                }
                case STYLE: {
                    style = v.getValue().toString();
                    break;
                }
                case LOCALE: {
                    locale = v.getValue().toString();
                    break;
                }
                case FORMAT: {
                    format = v.getValue().toString();
                    break;
                }
                case CITATION: {
                    citation = true;
                    break;
                }
                case LIST: {
                    list = true;
                    break;
                }
                case HELP: {
                    this.usage();
                    return 0;
                }
                case VERSION: {
                    this.version();
                    return 0;
                }
                case CITATIONID: {
                    citationIds.add(v.getValue().toString());
                }
            }
        }
        if (bibliography == null && !mendeley) {
            System.err.println("citeproc-java: no input bibliography specified.");
            return 1;
        }
        if (bibliography != null && mendeley) {
            System.err.println("citeproc-java: You can either specify an input bibliography file or let the tool read it from the Mendeley server, but not both.");
            return 1;
        }
        if (!(format.equals("text") || format.equals("html") || format.equals("asciidoc") || format.equals("fo") || format.equals("rtf"))) {
            System.err.println("citeproc-java: invalid output format: " + format);
            return 1;
        }
        ItemDataProvider provider = bibliography != null ? this.readBibliographyFile(bibliography) : this.readMendeley(mendeleySync);
        if (provider == null) {
            return 1;
        }
        if (list) {
            ArrayList<String> ids = new ArrayList<String>(Arrays.asList(provider.getIds()));
            Collections.sort(ids);
            for (String id : ids) {
                System.out.println(id);
            }
            return 0;
        }
        if (citation && citationIds.isEmpty()) {
            System.err.println("citeproc-java: no citation id specified.");
            return 1;
        }
        for (String id : citationIds) {
            if (provider.retrieveItem(id) != null) continue;
            System.err.println("citeproc-java: unknown citation id: " + id);
            String min = Levenshtein.findMinimum(Arrays.asList(provider.getIds()), id);
            System.err.println("Did you mean `" + min + "'?");
            return 1;
        }
        int ret = style.equals("json") ? this.generateJSON(citation, citationIds, provider) : this.generateCSL(style, locale, format, citation, citationIds, provider);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemDataProvider readBibliographyFile(String bibliography) throws FileNotFoundException, IOException {
        ListItemDataProvider provider;
        block11: {
            File bibfile = new File(bibliography);
            if (!bibfile.exists()) {
                System.err.println("citeproc-java: bibliography file `" + bibliography + "' does not exist.");
                return null;
            }
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(bibfile));
            try {
                FileFormat ff = this.determineFileFormat(bis);
                if (ff == FileFormat.BIBTEX) {
                    BibTeXDatabase db = new BibTeXConverter().loadDatabase(bis);
                    BibTeXItemDataProvider bibtexprovider = new BibTeXItemDataProvider();
                    bibtexprovider.addDatabase(db);
                    provider = bibtexprovider;
                    break block11;
                }
                if (ff == FileFormat.JSON_ARRAY || ff == FileFormat.JSON_OBJECT) {
                    List<Object> objs;
                    JsonParser parser = new JsonParser(new JsonLexer(new InputStreamReader(bis)));
                    if (ff == FileFormat.JSON_ARRAY) {
                        objs = parser.parseArray();
                    } else {
                        objs = new ArrayList<Object>();
                        objs.add(parser.parseObject());
                    }
                    CSLItemData[] items = new CSLItemData[objs.size()];
                    for (int i = 0; i < items.length; ++i) {
                        Map obj = (Map)objs.get(i);
                        items[i] = CSLItemData.fromJson(obj);
                    }
                    provider = new ListItemDataProvider(items);
                    break block11;
                }
                System.err.println("citeproc-java: unknown bibliography file format");
                ItemDataProvider itemDataProvider = null;
                return itemDataProvider;
            }
            catch (ParseException e) {
                System.err.println("citeproc-java: could not parse bibliography file.");
                System.err.println(e.getMessage());
                ItemDataProvider itemDataProvider = null;
                return itemDataProvider;
            }
            finally {
                bis.close();
            }
        }
        return provider;
    }

    private ItemDataProvider readMendeley(boolean sync) {
        CSLItemData[] items;
        FileAuthenticationStore authStore;
        String[] consumer;
        try {
            consumer = this.readConsumer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read Mendeley consumer key and secret");
        }
        File authStoreFile = new File(this.configDir, "mendeley-auth-store.conf");
        try {
            authStore = new FileAuthenticationStore(authStoreFile);
        }
        catch (IOException e) {
            System.err.println("citeproc-java: could not read user's authentication store: " + authStoreFile.getPath());
            return null;
        }
        MendeleyConnector dmc = new DefaultMendeleyConnector(consumer[1], consumer[0]);
        dmc = new AuthenticatedMendeleyConnector(dmc, authStore);
        File cacheFile = new File(this.configDir, "mendeley-cache.dat");
        CachingMendeleyConnector mc = new CachingMendeleyConnector(dmc, cacheFile);
        if (sync) {
            mc.clear();
        }
        int retries = 1;
        while (true) {
            try {
                boolean cacheempty = false;
                if (!mc.hasDocumentList()) {
                    System.out.print("Retrieving documents ...");
                    cacheempty = true;
                }
                List<String> docs = mc.getDocuments();
                if (cacheempty) {
                    System.out.println();
                }
                items = new CSLItemData[docs.size()];
                int i = 0;
                int printed = 0;
                for (String did : docs) {
                    CSLItemData item;
                    if (!mc.containsDocumentId(did)) {
                        String msg = String.format("\rSynchronizing (%d/%d) ...", i + 1, docs.size());
                        System.out.print(msg);
                        ++printed;
                    }
                    items[i] = item = mc.getDocument(did);
                    ++i;
                }
                if (printed <= 0) break;
                System.out.println();
            }
            catch (UnauthorizedException e) {
                if (retries == 0) {
                    System.err.println("citeproc-java: failed to authorize.");
                    return null;
                }
                --retries;
                if (this.mendeleyAuthorize(mc)) continue;
                return null;
            }
            catch (RequestException e) {
                System.err.println("citeproc-java: " + e.getMessage());
                return null;
            }
            catch (IOException e) {
                System.err.println("citeproc-java: could not get list of documents from Mendeley server.");
                return null;
            }
            break;
        }
        return new ListItemDataProvider(items);
    }

    private boolean mendeleyAuthorize(MendeleyConnector mc) {
        String verificationCode;
        Desktop d;
        String authUrl;
        try {
            authUrl = mc.getAuthorizationURL();
        }
        catch (IOException e) {
            System.err.println("citeproc-java: could not get authorization URL from Mendeley server.");
            return false;
        }
        System.out.println("This tool requires authorization. Please point your web browser to the\nfollowing URL and follow the instructions:\n");
        System.out.println(authUrl);
        System.out.println();
        if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                d.browse(new URI(authUrl));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.print("Enter verification code: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            verificationCode = br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read from console.");
        }
        try {
            System.out.println("Connecting ...");
            mc.authorize(verificationCode);
        }
        catch (IOException e) {
            System.err.println("citeproc-java: Mendeley server refused authorization.");
            return false;
        }
        return true;
    }

    private String[] readConsumer() throws Exception {
        int i;
        String str = CSLUtils.readStreamToString(CSLTool.class.getResourceAsStream("helper/tool/internal/citeproc-java-tool-consumer"), "UTF-8");
        byte[] arr = DatatypeConverter.parseBase64Binary((String)str);
        SecretKeySpec k = new SecretKeySpec("#x$gbf5zs%4QvzAx".getBytes(), "AES");
        Cipher c = Cipher.getInstance("AES");
        c.init(2, k);
        arr = c.doFinal(arr);
        arr = DatatypeConverter.parseBase64Binary((String)new String(arr));
        String[] result = new String[]{"", ""};
        for (i = 0; i < 32; ++i) {
            result[0] = result[0] + (char)arr[i + 31];
        }
        for (i = 0; i < 41; ++i) {
            result[1] = result[1] + (char)arr[i + 1857];
        }
        return result;
    }

    private int generateJSON(boolean citation, List<String> citationIds, ItemDataProvider provider) {
        StringJsonBuilderFactory factory = new StringJsonBuilderFactory();
        if (citation) {
            JsonBuilder b = factory.createJsonBuilder();
            String s = (String)b.toJson(citationIds.toArray(new String[citationIds.size()]));
            System.out.println(s);
        } else {
            System.out.print("[");
            List<String> ids = citationIds;
            if (ids.isEmpty()) {
                ids = Arrays.asList(provider.getIds());
            }
            int i = 0;
            for (String id : ids) {
                if (i > 0) {
                    System.out.print(",");
                }
                CSLItemData item = provider.retrieveItem(id);
                JsonBuilder b = factory.createJsonBuilder();
                System.out.print(item.toJson(b));
                ++i;
            }
            System.out.println("]");
        }
        return 0;
    }

    private int generateCSL(String style, String locale, String format, boolean citation, List<String> citationIds, ItemDataProvider provider) throws IOException {
        CSL citeproc;
        try {
            citeproc = new CSL(provider, style, locale);
        }
        catch (FileNotFoundException e) {
            System.err.println("citeproc-java: " + e.getMessage());
            return 1;
        }
        citeproc.setOutputFormat(format);
        String[] citationIdsArr = new String[citationIds.size()];
        citationIdsArr = citationIds.toArray(citationIdsArr);
        if (citationIds.isEmpty()) {
            citeproc.registerCitationItems(provider.getIds());
        } else {
            citeproc.registerCitationItems(citationIdsArr);
        }
        if (citation) {
            List<Citation> cits = citeproc.makeCitation(citationIdsArr);
            for (Citation c : cits) {
                System.out.println(c.getText());
            }
        } else {
            Bibliography bibl = citeproc.makeBibliography();
            System.out.println(bibl.makeString());
        }
        return 0;
    }

    private void version() {
        String version;
        URL u = CSLTool.class.getResource("version.dat");
        try {
            version = CSLUtils.readURLToString(u, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read version information", e);
        }
        System.out.println("citeproc-java " + version);
    }

    private void usage() {
        OptionParser.usage("citeproc-java [OPTION]... [CITATION ID]...", "Generate styled citations and bibliographies", options, System.out);
    }

    private FileFormat determineFileFormat(BufferedInputStream bis) throws IOException {
        int len = 102400;
        bis.mark(len);
        try {
            while (true) {
                int c = bis.read();
                --len;
                if (c < 0) {
                    FileFormat fileFormat = FileFormat.UNKNOWN;
                    return fileFormat;
                }
                if (len < 2) {
                    FileFormat fileFormat = FileFormat.UNKNOWN;
                    return fileFormat;
                }
                if (Character.isWhitespace(c)) continue;
                if (c == 37 || c == 64) {
                    FileFormat fileFormat = FileFormat.BIBTEX;
                    return fileFormat;
                }
                if (c == 91) {
                    FileFormat fileFormat = FileFormat.JSON_ARRAY;
                    return fileFormat;
                }
                if (c == 123) {
                    FileFormat fileFormat = FileFormat.JSON_OBJECT;
                    return fileFormat;
                }
                FileFormat fileFormat = FileFormat.UNKNOWN;
                return fileFormat;
            }
        }
        finally {
            bis.reset();
        }
    }

    private static enum FileFormat {
        BIBTEX,
        JSON_OBJECT,
        JSON_ARRAY,
        UNKNOWN;

    }

    private static enum OID {
        BIBLIOGRAPHY,
        MENDELEY,
        MENDELEY_SYNC,
        STYLE,
        LOCALE,
        FORMAT,
        CITATION,
        LIST,
        HELP,
        VERSION,
        CITATIONID;

    }
}

