/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.AbbreviationProvider;
import de.undercouch.citeproc.DefaultAbbreviationProvider;
import de.undercouch.citeproc.DefaultLocaleProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.SelectionMode;
import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CitationIDIndexPair;
import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.MapJsonBuilderFactory;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.Citation;
import de.undercouch.citeproc.output.SecondFieldAlign;
import de.undercouch.citeproc.script.ScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import de.undercouch.citeproc.script.ScriptRunnerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class CSL {
    private final ScriptRunner runner = ScriptRunnerFactory.createRunner();

    public CSL(ItemDataProvider itemDataProvider, String style) throws IOException {
        this(itemDataProvider, style, "en-US");
    }

    public CSL(ItemDataProvider itemDataProvider, AbbreviationProvider abbreviationProvider, String style) throws IOException {
        this(itemDataProvider, abbreviationProvider, style, "en-US");
    }

    public CSL(ItemDataProvider itemDataProvider, String style, String lang) throws IOException {
        this(itemDataProvider, new DefaultLocaleProvider(), style, lang, false);
    }

    public CSL(ItemDataProvider itemDataProvider, AbbreviationProvider abbreviationProvider, String style, String lang) throws IOException {
        this(itemDataProvider, new DefaultLocaleProvider(), abbreviationProvider, style, lang, false);
    }

    public CSL(ItemDataProvider itemDataProvider, LocaleProvider localeProvider, String style, String lang, boolean forceLang) throws IOException {
        this(itemDataProvider, localeProvider, new DefaultAbbreviationProvider(), style, lang, forceLang);
    }

    public CSL(ItemDataProvider itemDataProvider, LocaleProvider localeProvider, AbbreviationProvider abbreviationProvider, String style, String lang, boolean forceLang) throws IOException {
        this.runner.put("__scriptRunner__", this.runner);
        this.runner.put("__itemDataProvider__", itemDataProvider);
        this.runner.put("__localeProvider__", localeProvider);
        this.runner.put("__abbreviationProvider__", abbreviationProvider);
        try {
            this.runner.loadScript(this.getClass().getResource("xmle4x.js"));
            this.runner.loadScript(this.getClass().getResource("citeproc.js"));
            this.runner.loadScript(this.getClass().getResource("formats.js"));
            this.runner.loadScript(this.getClass().getResource("loadsys.js"));
        }
        catch (ScriptRunnerException e) {
            throw new RuntimeException("Invalid bundled javascript file", e);
        }
        if (!this.isStyle(style)) {
            style = this.loadStyle(style);
        }
        try {
            this.runner.eval("var __engine__ = new CSL.Engine(Sys, \"" + StringEscapeUtils.escapeJava((String)style) + "\", \"" + StringEscapeUtils.escapeJava((String)lang) + "\", " + forceLang + ");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not parse arguments", e);
        }
    }

    protected ScriptRunner getScriptRunner() {
        return this.runner;
    }

    private boolean isStyle(String style) {
        for (int i = 0; i < style.length(); ++i) {
            char c = style.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '<';
        }
        return false;
    }

    private String loadStyle(String styleName) throws IOException {
        URL url;
        if (!styleName.endsWith(".csl")) {
            styleName = styleName + ".csl";
        }
        if (!styleName.startsWith("/")) {
            styleName = "/" + styleName;
        }
        if ((url = this.getClass().getResource(styleName)) == null) {
            throw new FileNotFoundException("Could not find style in classpath: " + styleName);
        }
        return CSLUtils.readURLToString(url, "UTF-8");
    }

    public void setOutputFormat(String format) {
        try {
            this.runner.eval("__engine__.setOutputFormat(\"" + StringEscapeUtils.escapeJava((String)format) + "\");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not set output format", e);
        }
    }

    public void setConvertLinks(boolean convert) {
        try {
            this.runner.eval("__engine__.opt.development_extensions.wrap_url_and_doi = " + convert + ";");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not set option", e);
        }
    }

    public void setAbbreviations(String name) {
        try {
            this.runner.eval("__engine__.setAbbreviations(\"" + StringEscapeUtils.escapeJava((String)name) + "\");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not set abbreviations", e);
        }
    }

    public void registerCitationItems(String ... ids) {
        try {
            this.runner.callMethod("__engine__", "updateItems", ids);
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not update items", e);
        }
    }

    public void registerCitationItems(String[] ids, boolean unsorted) {
        try {
            this.runner.callMethod("__engine__", "updateItems", ids, unsorted);
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not update items", e);
        }
    }

    public List<Citation> makeCitation(String ... ids) {
        CSLCitationItem[] items = new CSLCitationItem[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            items[i] = new CSLCitationItem(ids[i]);
        }
        return this.makeCitation(new CSLCitation(items));
    }

    public List<Citation> makeCitation(CSLCitation citation) {
        return this.makeCitation(citation, null, null);
    }

    public List<Citation> makeCitation(CSLCitation citation, List<CitationIDIndexPair> citationsPre, List<CitationIDIndexPair> citationsPost) {
        List r;
        block5: {
            try {
                if (citationsPre == null && citationsPost == null) {
                    r = (List)this.runner.callMethod("__engine__", "appendCitationCluster", citation);
                    break block5;
                }
                r = (List)this.runner.callMethod("__engine__", "processCitationCluster", citation, citationsPre, citationsPost);
                for (Object o : r) {
                    if (!(o instanceof List)) continue;
                    r = (List)o;
                    break;
                }
            }
            catch (ScriptRunnerException e) {
                throw new IllegalArgumentException("Could not make citation", e);
            }
        }
        ArrayList<Citation> result = new ArrayList<Citation>();
        for (Object o : r) {
            List i;
            if (!(o instanceof List) || !((i = (List)o).get(0) instanceof Number) || !(i.get(1) instanceof CharSequence)) continue;
            int index = ((Number)i.get(0)).intValue();
            String text = i.get(1).toString();
            result.add(new Citation(index, text));
        }
        return result;
    }

    public Bibliography makeBibliography() {
        return this.makeBibliography(null, new CSLItemData[0]);
    }

    public Bibliography makeBibliography(SelectionMode mode, CSLItemData ... selection) {
        return this.makeBibliography(mode, selection, (CSLItemData[])null);
    }

    public Bibliography makeBibliography(SelectionMode mode, CSLItemData[] selection, CSLItemData[] quash) {
        List r;
        try {
            if ((selection == null || mode == null) && quash == null) {
                r = (List)this.runner.eval("__engine__.makeBibliography();");
            } else {
                HashMap<String, List<Map<String, Object>>> args = new HashMap<String, List<Map<String, Object>>>();
                if (selection != null && mode != null) {
                    args.put(mode.toString(), this.selectionToList(selection));
                }
                if (quash != null) {
                    args.put("quash", this.selectionToList(quash));
                }
                r = (List)this.runner.callMethod("__engine__", "makeBibliography", args);
            }
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not make bibliography", e);
        }
        Map fpm = (Map)r.get(0);
        List entriesList = (List)r.get(1);
        String[] entries = new String[entriesList.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = ((CharSequence)entriesList.get(i)).toString();
        }
        int maxOffset = this.getFromMap((Map<String, Object>)fpm, "maxoffset", 0);
        int entrySpacing = this.getFromMap((Map<String, Object>)fpm, "entryspacing", 0);
        int lineSpacing = this.getFromMap((Map<String, Object>)fpm, "linespacing", 0);
        int hangingIndent = this.getFromMap((Map<String, Object>)fpm, "hangingindent", 0);
        boolean done = this.getFromMap((Map<String, Object>)fpm, "done", false);
        Collection srcEntryIds = (Collection)fpm.get("entry_ids");
        ArrayList<String> dstEntryIds = new ArrayList<String>();
        for (Object o : srcEntryIds) {
            if (o instanceof Collection) {
                Collection oc = (Collection)o;
                for (Object oco : oc) {
                    dstEntryIds.add(oco.toString());
                }
                continue;
            }
            dstEntryIds.add(o.toString());
        }
        String[] entryIds = dstEntryIds.toArray(new String[dstEntryIds.size()]);
        SecondFieldAlign secondFieldAlign = SecondFieldAlign.FALSE;
        Object sfa = fpm.get("second-field-align");
        if (sfa != null) {
            secondFieldAlign = SecondFieldAlign.fromString(sfa.toString());
        }
        String bibStart = this.getFromMap((Map<String, Object>)fpm, "bibstart", "");
        String bibEnd = this.getFromMap((Map<String, Object>)fpm, "bibend", "");
        return new Bibliography(entries, bibStart, bibEnd, entryIds, maxOffset, entrySpacing, lineSpacing, hangingIndent, done, secondFieldAlign);
    }

    private List<Map<String, Object>> selectionToList(CSLItemData[] selection) {
        MapJsonBuilderFactory mjbf = new MapJsonBuilderFactory();
        ArrayList<Map<String, Object>> sl = new ArrayList<Map<String, Object>>();
        for (CSLItemData item : selection) {
            JsonBuilder jb = mjbf.createJsonBuilder();
            Map mi = (Map)item.toJson(jb);
            for (Map.Entry<String, Object> entry : mi.entrySet()) {
                Object v = entry.getValue();
                if (((String)entry.getKey()).equals("id") && v instanceof String && ((String)v).startsWith("-GEN-")) continue;
                if (v instanceof Collection) {
                    Collection coll = (Collection)v;
                    if (coll.isEmpty()) {
                        this.putSelectionFieldValue(sl, entry, "");
                        continue;
                    }
                    for (Object ao : coll) {
                        this.putSelectionFieldValue(sl, entry, ao);
                    }
                    continue;
                }
                if (v instanceof Map && ((Map)v).isEmpty()) {
                    this.putSelectionFieldValue(sl, entry, "");
                    continue;
                }
                this.putSelectionFieldValue(sl, entry, v);
            }
        }
        return sl;
    }

    private void putSelectionFieldValue(List<Map<String, Object>> sl, Map.Entry<String, Object> e, Object v) {
        HashMap<String, Object> sf = new HashMap<String, Object>(2);
        sf.put("field", e.getKey());
        sf.put("value", v);
        sl.add(sf);
    }

    private int getFromMap(Map<String, Object> m, String key, int def) {
        Number r = (Number)m.get(key);
        if (r == null) {
            return def;
        }
        return r.intValue();
    }

    private boolean getFromMap(Map<String, Object> m, String key, boolean def) {
        Object r = m.get(key);
        if (r == null) {
            return def;
        }
        if (r instanceof CharSequence) {
            return Boolean.parseBoolean(r.toString());
        }
        return (Boolean)r;
    }

    private String getFromMap(Map<String, Object> m, String key, String def) {
        String r = (String)m.get(key);
        if (r == null) {
            r = def;
        }
        return r;
    }

    public void reset() {
        try {
            this.runner.eval("__engine__.restoreProcessorState();");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not reset processor state", e);
        }
    }

    public static Bibliography makeAdhocBibliography(String style, CSLItemData ... items) throws IOException {
        return CSL.makeAdhocBibliography(style, "html", items);
    }

    public static Bibliography makeAdhocBibliography(String style, String outputFormat, CSLItemData ... items) throws IOException {
        ListItemDataProvider provider = new ListItemDataProvider(items);
        CSL csl = new CSL(provider, style);
        csl.setOutputFormat(outputFormat);
        String[] ids = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ids[i] = items[i].getId();
        }
        csl.registerCitationItems(ids);
        return csl.makeBibliography();
    }
}

