/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.script.ScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class RhinoScriptRunner
implements ScriptRunner {
    private final Scriptable scope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptRunner() {
        Context context = Context.enter();
        try {
            this.scope = context.initStandardObjects();
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public void put(String key, Object value) {
        this.scope.put(key, this.scope, value);
    }

    @Override
    public Object eval(String code) throws ScriptRunnerException {
        Context context = Context.enter();
        try {
            Object object = RhinoScriptRunner.unwrap(context.evaluateString(this.scope, code, "<code>", 1, null));
            return object;
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not execute code", e);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptRunnerException, IOException {
        Context context = Context.enter();
        try {
            Object object = RhinoScriptRunner.unwrap(context.evaluateReader(this.scope, reader, "<code>", 1, null));
            return object;
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not execute script", e);
        }
        finally {
            Context.exit();
        }
    }

    private static Object unwrap(Object o) {
        if (o instanceof Wrapper) {
            return ((Wrapper)o).unwrap();
        }
        return o;
    }
}

