/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import de.undercouch.citeproc.helper.JsonObject;
import java.lang.reflect.Array;
import org.apache.commons.lang.StringEscapeUtils;

public class JsonHelper {
    public static String toJson(Object obj) {
        if (obj instanceof JsonObject) {
            return JsonHelper.toJson((JsonObject)obj);
        }
        if (obj instanceof Number) {
            return JsonHelper.toJson((Number)obj);
        }
        if (obj instanceof Boolean) {
            return JsonHelper.toJson((Boolean)obj);
        }
        if (obj.getClass().isArray()) {
            StringBuffer r = new StringBuffer();
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object ao = Array.get(obj, i);
                if (r.length() > 0) {
                    r.append(",");
                }
                r.append(JsonHelper.toJson(ao));
            }
            return "[" + r.toString() + "]";
        }
        return JsonHelper.toJson(String.valueOf(obj));
    }

    public static String toJson(JsonObject obj) {
        return obj.toJson();
    }

    public static String toJson(String s) {
        return "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
    }

    public static String toJson(boolean b) {
        return String.valueOf(b);
    }

    public static String toJson(Number n) {
        return String.valueOf(n);
    }
}

