/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLProperties;
import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.helper.JsonObject;

public class CSLCitation
implements JsonObject {
    private final CSLCitationItem[] citationItems;
    private final String citationID;
    private final CSLProperties properties;

    public CSLCitation(CSLCitationItem ... citationItems) {
        this.citationItems = citationItems;
        this.citationID = Long.toString((long)Math.floor(Math.random() * 1.0E14), 32);
        this.properties = new CSLProperties();
    }

    public CSLCitation(CSLCitationItem[] citationItems, String citationID, CSLProperties properties) {
        this.citationItems = citationItems;
        this.citationID = citationID;
        this.properties = properties;
    }

    public CSLCitationItem[] getCitationItems() {
        return this.citationItems;
    }

    public String getCitationID() {
        return this.citationID;
    }

    public CSLProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toJson() {
        StringBuilder r = new StringBuilder("{");
        r.append("\"citationItems\": " + JsonHelper.toJson(this.citationItems));
        if (this.citationID != null) {
            r.append(",\"citationID\": " + JsonHelper.toJson(this.citationID));
        }
        if (this.properties != null) {
            r.append(",\"properties\": " + JsonHelper.toJson(this.properties));
        }
        r.append("}");
        return r.toString();
    }

    public String toString() {
        return this.toJson();
    }
}

