/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.DefaultLocaleProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.Citation;
import de.undercouch.citeproc.output.FormattingParameters;
import de.undercouch.citeproc.script.ScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import de.undercouch.citeproc.script.ScriptRunnerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class CSL {
    private final ScriptRunner runner = ScriptRunnerFactory.createRunner();

    public CSL(ItemDataProvider itemDataProvider, String style) throws IOException {
        this(itemDataProvider, style, "en-US");
    }

    public CSL(ItemDataProvider itemDataProvider, String style, String lang) throws IOException {
        this(itemDataProvider, new DefaultLocaleProvider(), style, lang, false);
    }

    public CSL(ItemDataProvider itemDataProvider, LocaleProvider localeProvider, String style, String lang, boolean forceLang) throws IOException {
        this.runner.put("__itemDataProvider__", itemDataProvider);
        this.runner.put("__localeProvider__", localeProvider);
        try {
            this.evaluateScript("/xmle4x.js");
            this.evaluateScript("/citeproc.js");
            this.evaluateScript("/formats.js");
            this.evaluateScript("/loadsys.js");
        }
        catch (ScriptRunnerException e) {
            throw new RuntimeException("Invalid bundled javascript file", e);
        }
        if (!this.isStyle(style)) {
            style = this.loadStyle(style);
        }
        try {
            this.runner.eval("var __engine__ = new CSL.Engine(Sys, \"" + StringEscapeUtils.escapeJava((String)style) + "\", \"" + StringEscapeUtils.escapeJava((String)lang) + "\", " + forceLang + ");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not parse arguments", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateScript(String filename) throws IOException, ScriptRunnerException {
        URL citeProcURL = this.getClass().getResource(filename);
        if (citeProcURL == null) {
            throw new FileNotFoundException("Could not find " + filename + " in classpath");
        }
        InputStreamReader reader = new InputStreamReader(citeProcURL.openStream());
        try {
            this.runner.eval(reader);
        }
        finally {
            reader.close();
        }
    }

    private boolean isStyle(String style) {
        for (int i = 0; i < style.length(); ++i) {
            char c = style.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '<';
        }
        return false;
    }

    private String loadStyle(String styleName) throws IOException {
        URL url = this.getClass().getResource("/" + styleName + ".csl");
        if (url == null) {
            throw new FileNotFoundException("Could not find style in classpath: " + styleName);
        }
        return CSLUtils.readURLToString(url, "UTF-8");
    }

    public void setOutputFormat(String format) {
        try {
            this.runner.eval("__engine__.setOutputFormat(\"" + StringEscapeUtils.escapeJava((String)format) + "\");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not set output format", e);
        }
    }

    public void setConvertLinks(boolean convert) {
        try {
            this.runner.eval("__engine__.opt.development_extensions.wrap_url_and_doi = " + convert + ";");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not set option", e);
        }
    }

    public void registerCitationItems(String ... ids) {
        try {
            this.runner.eval("__engine__.updateItems(" + JsonHelper.toJson(ids) + ");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not update items", e);
        }
    }

    public List<Citation> makeCitation(String ... ids) {
        CSLCitationItem[] items = new CSLCitationItem[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            items[i] = new CSLCitationItem(ids[i]);
        }
        return this.makeCitation(new CSLCitation(items));
    }

    public List<Citation> makeCitation(CSLCitation citation) {
        List r;
        try {
            List rr;
            r = rr = (List)this.runner.eval("__engine__.appendCitationCluster(" + JsonHelper.toJson(citation) + ");");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not append citation cluster", e);
        }
        ArrayList<Citation> result = new ArrayList<Citation>();
        for (Object o : r) {
            List i;
            if (!(o instanceof List) || !((i = (List)o).get(0) instanceof Number) || !(i.get(1) instanceof CharSequence)) continue;
            int index = ((Number)i.get(0)).intValue();
            String text = i.get(1).toString();
            result.add(new Citation(index, text));
        }
        return result;
    }

    public Bibliography makeBibliography() {
        List r;
        try {
            List rr;
            r = rr = (List)this.runner.eval("__engine__.makeBibliography();");
        }
        catch (ScriptRunnerException e) {
            throw new IllegalArgumentException("Could not make bibliography", e);
        }
        Map fpm = (Map)r.get(0);
        List entriesList = (List)r.get(1);
        String[] entries = new String[entriesList.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = ((Object)((CharSequence)entriesList.get(i))).toString();
        }
        int maxOffset = this.getFromMap((Map<String, Object>)fpm, "maxoffset", 0);
        int entrySpacing = this.getFromMap((Map<String, Object>)fpm, "entryspacing", 0);
        int lineSpacing = this.getFromMap((Map<String, Object>)fpm, "linespacing", 0);
        int hangingIndent = this.getFromMap((Map<String, Object>)fpm, "hangingindent", 0);
        boolean secondFieldAlign = this.getFromMap((Map<String, Object>)fpm, "second-field-align", false);
        String bibStart = this.getFromMap((Map<String, Object>)fpm, "bibstart", "");
        String bibEnd = this.getFromMap((Map<String, Object>)fpm, "bibend", "");
        FormattingParameters fp = new FormattingParameters(maxOffset, entrySpacing, lineSpacing, hangingIndent, secondFieldAlign, bibStart, bibEnd);
        return new Bibliography(entries, fp);
    }

    private int getFromMap(Map<String, Object> m, String key, int def) {
        Number r = (Number)m.get(key);
        if (r == null) {
            return def;
        }
        return r.intValue();
    }

    private boolean getFromMap(Map<String, Object> m, String key, boolean def) {
        Object r = m.get(key);
        if (r == null) {
            return def;
        }
        if (r instanceof CharSequence) {
            return Boolean.parseBoolean(r.toString());
        }
        return (Boolean)r;
    }

    private String getFromMap(Map<String, Object> m, String key, String def) {
        String r = (String)m.get(key);
        if (r == null) {
            r = def;
        }
        return r;
    }

    public static Bibliography makeAdhocBibliography(String style, CSLItemData ... items) throws IOException {
        return CSL.makeAdhocBibliography(style, "html", items);
    }

    public static Bibliography makeAdhocBibliography(String style, String outputFormat, CSLItemData ... items) throws IOException {
        ListItemDataProvider provider = new ListItemDataProvider(items);
        CSL csl = new CSL(provider, style);
        csl.setOutputFormat(outputFormat);
        String[] ids = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ids[i] = items[i].getId();
        }
        csl.registerCitationItems(ids);
        return csl.makeBibliography();
    }
}

