// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.output;

/**
 * Formatting parameters for a generated bibliography.
 * 
 * @author Michel Kraemer
 */
public class FormattingParameters {
	private final Integer maxOffset;
	private final Integer entrySpacing;
	private final Integer lineSpacing;
	private final Integer hangingIndent;
	private final Boolean secondFieldAlign;
	private final String bibStart;
	private final String bibEnd;

	public FormattingParameters() {
		this.maxOffset = null;
		this.entrySpacing = null;
		this.lineSpacing = null;
		this.hangingIndent = null;
		this.secondFieldAlign = null;
		this.bibStart = null;
		this.bibEnd = null;

	}

	public FormattingParameters(Integer maxOffset, Integer entrySpacing,
			Integer lineSpacing, Integer hangingIndent,
			Boolean secondFieldAlign, String bibStart, String bibEnd) {
		this.maxOffset = maxOffset;
		this.entrySpacing = entrySpacing;
		this.lineSpacing = lineSpacing;
		this.hangingIndent = hangingIndent;
		this.secondFieldAlign = secondFieldAlign;
		this.bibStart = bibStart;
		this.bibEnd = bibEnd;

	}

	/**
	 * @return the maxoffset
	 */
	public Integer getMaxOffset() {
		return maxOffset;
	}
	/**
	 * @return the entryspacing
	 */
	public Integer getEntrySpacing() {
		return entrySpacing;
	}
	/**
	 * @return the linespacing
	 */
	public Integer getLineSpacing() {
		return lineSpacing;
	}
	/**
	 * @return the hangingindent
	 */
	public Integer getHangingIndent() {
		return hangingIndent;
	}
	/**
	 * @return the second-field-align
	 */
	public Boolean getSecondFieldAlign() {
		return secondFieldAlign;
	}
	/**
	 * @return the bibstart
	 */
	public String getBibStart() {
		return bibStart;
	}
	/**
	 * @return the bibend
	 */
	public String getBibEnd() {
		return bibEnd;
	}

}
