// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.output;

/**
 * A generated citation that can be put into the text
 * 
 * @author Michel Kraemer
 */
public class Citation {
	private final int index;
	private final String text;

	public Citation(int index, String text) {
		this.index = index;
		this.text = text;

	}

	/**
	 * @return the citation's index
	 */
	public int getIndex() {
		return index;
	}
	/**
	 * @return the citation's text
	 */
	public String getText() {
		return text;
	}

}
