// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.output;

/**
 * A generated bibliography consisting of bibliography entries and some
 * formatting parameters
 * 
 * @author Michel Kraemer
 */
public class Bibliography {
	private final String[] entries;

	private final FormattingParameters parameters;

	public Bibliography(String... entries) {
		this.entries = entries;

		this.parameters = null;

	}

	public Bibliography(String[] entries, FormattingParameters parameters) {
		this.entries = entries;

		this.parameters = parameters;

	}

	/**
	 * @return the bibliography's entries
	 */
	public String[] getEntries() {
		return entries;
	}

	/**
	 * @return the bibliography's parameters
	 */
	public FormattingParameters getParameters() {
		return parameters;
	}

	/**
	 * Converts this bibliography to a String that can be inserted into the text
	 */
	public String makeString() {
		StringBuilder b = new StringBuilder();
		if (parameters != null && parameters.getBibStart() != null)
			b.append(parameters.getBibStart());
		if (entries != null) {
			for (String e : entries)
				b.append(e);
		}
		if (parameters != null && parameters.getBibEnd() != null)
			b.append(parameters.getBibEnd());
		return b.toString();
	}
}
