// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Valid citation item types.
 * 
 * @author Michel Kraemer
 */
public enum CSLType {
	ARTICLE("article"), ARTICLE_JOURNAL("article-journal"), ARTICLE_MAGAZINE(
			"article-magazine"), ARTICLE_NEWSPAPER("article-newspaper"), BILL(
			"bill"), BOOK("book"), BROADCAST("broadcast"), CHAPTER("chapter"), DATASET(
			"dataset"), ENTRY("entry"), ENTRY_DICTIONARY("entry-dictionary"), ENTRY_ENCYCLOPEDIA(
			"entry-encyclopedia"), FIGURE("figure"), GRAPHIC("graphic"), INTERVIEW(
			"interview"), LEGAL_CASE("legal_case"), LEGISLATION("legislation"), MANUSCRIPT(
			"manuscript"), MAP("map"), MOTION_PICTURE("motion_picture"), MUSICAL_SCORE(
			"musical_score"), PAMPHLET("pamphlet"), PAPER_CONFERENCE(
			"paper-conference"), PATENT("patent"), PERSONAL_COMMUNICATION(
			"personal_communication"), POST("post"), POST_WEBLOG("post-weblog"), REPORT(
			"report"), REVIEW("review"), REVIEW_BOOK("review-book"), SONG(
			"song"), SPEECH("speech"), THESIS("thesis"), TREATY("treaty"), WEBPAGE(
			"webpage");

	private String name;

	private CSLType(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}
}
