// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.helper.JsonObject;

/**
 * Citation cluster properties.
 * 
 * @author Michel Kraemer
 */
public class CSLProperties implements JsonObject {
	private final Integer noteIndex;

	public CSLProperties() {
		this.noteIndex = 0;

	}

	public CSLProperties(Integer noteIndex) {
		this.noteIndex = noteIndex;

	}

	/**
	 * @return the noteIndex
	 */
	public Integer getNoteIndex() {
		return noteIndex;
	}

	@Override
	public String toJson() {
		StringBuilder r = new StringBuilder("{");
		if (noteIndex != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"noteIndex\": " + JsonHelper.toJson(noteIndex));
		}

		r.append("}");
		return r.toString();
	}

	@Override
	public String toString() {
		return toJson();
	}

}
