// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Builder for {@link CSLName}
 * 
 * @author Michel Kraemer
 */
public class CSLNameBuilder {
	private String family;
	private String given;
	private String droppingParticle;
	private String nonDroppingParticle;
	private String suffix;
	private Boolean commaPrefix;
	private Boolean staticOrdering;
	private String literal;
	private Boolean parseNames;

	public CSLNameBuilder() {
		this.family = null;
		this.given = null;
		this.droppingParticle = null;
		this.nonDroppingParticle = null;
		this.suffix = null;
		this.commaPrefix = null;
		this.staticOrdering = null;
		this.literal = null;
		this.parseNames = null;

	}

	public CSLNameBuilder family(String family) {
		this.family = family;
		return this;
	}
	public CSLNameBuilder given(String given) {
		this.given = given;
		return this;
	}
	public CSLNameBuilder droppingParticle(String droppingParticle) {
		this.droppingParticle = droppingParticle;
		return this;
	}
	public CSLNameBuilder nonDroppingParticle(String nonDroppingParticle) {
		this.nonDroppingParticle = nonDroppingParticle;
		return this;
	}
	public CSLNameBuilder suffix(String suffix) {
		this.suffix = suffix;
		return this;
	}
	public CSLNameBuilder commaPrefix(Boolean commaPrefix) {
		this.commaPrefix = commaPrefix;
		return this;
	}
	public CSLNameBuilder staticOrdering(Boolean staticOrdering) {
		this.staticOrdering = staticOrdering;
		return this;
	}
	public CSLNameBuilder literal(String literal) {
		this.literal = literal;
		return this;
	}
	public CSLNameBuilder parseNames(Boolean parseNames) {
		this.parseNames = parseNames;
		return this;
	}

	public CSLName build() {
		return new CSLName(family, given, droppingParticle,
				nonDroppingParticle, suffix, commaPrefix, staticOrdering,
				literal, parseNames);
	}

}
