// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.helper.JsonObject;

/**
 * A human being's name
 * 
 * @author Michel Kraemer
 */
public class CSLName implements JsonObject {
	private final String family;
	private final String given;
	private final String droppingParticle;
	private final String nonDroppingParticle;
	private final String suffix;
	private final Boolean commaPrefix;
	private final Boolean staticOrdering;
	private final String literal;
	private final Boolean parseNames;

	public CSLName() {
		this.family = null;
		this.given = null;
		this.droppingParticle = null;
		this.nonDroppingParticle = null;
		this.suffix = null;
		this.commaPrefix = null;
		this.staticOrdering = null;
		this.literal = null;
		this.parseNames = null;

	}

	public CSLName(String family, String given, String droppingParticle,
			String nonDroppingParticle, String suffix, Boolean commaPrefix,
			Boolean staticOrdering, String literal, Boolean parseNames) {
		this.family = family;
		this.given = given;
		this.droppingParticle = droppingParticle;
		this.nonDroppingParticle = nonDroppingParticle;
		this.suffix = suffix;
		this.commaPrefix = commaPrefix;
		this.staticOrdering = staticOrdering;
		this.literal = literal;
		this.parseNames = parseNames;

	}

	/**
	 * @return the family
	 */
	public String getFamily() {
		return family;
	}
	/**
	 * @return the given
	 */
	public String getGiven() {
		return given;
	}
	/**
	 * @return the dropping-particle
	 */
	public String getDroppingParticle() {
		return droppingParticle;
	}
	/**
	 * @return the non-dropping-particle
	 */
	public String getNonDroppingParticle() {
		return nonDroppingParticle;
	}
	/**
	 * @return the suffix
	 */
	public String getSuffix() {
		return suffix;
	}
	/**
	 * @return the comma-prefix
	 */
	public Boolean getCommaPrefix() {
		return commaPrefix;
	}
	/**
	 * @return the static-ordering
	 */
	public Boolean getStaticOrdering() {
		return staticOrdering;
	}
	/**
	 * @return the literal
	 */
	public String getLiteral() {
		return literal;
	}
	/**
	 * @return the parse-names
	 */
	public Boolean getParseNames() {
		return parseNames;
	}

	@Override
	public String toJson() {
		StringBuilder r = new StringBuilder("{");
		if (family != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"family\": " + JsonHelper.toJson(family));
		}
		if (given != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"given\": " + JsonHelper.toJson(given));
		}
		if (droppingParticle != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"dropping-particle\": "
					+ JsonHelper.toJson(droppingParticle));
		}
		if (nonDroppingParticle != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"non-dropping-particle\": "
					+ JsonHelper.toJson(nonDroppingParticle));
		}
		if (suffix != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"suffix\": " + JsonHelper.toJson(suffix));
		}
		if (commaPrefix != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"comma-prefix\": " + JsonHelper.toJson(commaPrefix));
		}
		if (staticOrdering != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"static-ordering\": "
					+ JsonHelper.toJson(staticOrdering));
		}
		if (literal != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"literal\": " + JsonHelper.toJson(literal));
		}
		if (parseNames != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"parse-names\": " + JsonHelper.toJson(parseNames));
		}

		r.append("}");
		return r.toString();
	}

	@Override
	public String toString() {
		return toJson();
	}

}
