// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Valid citation labels
 * 
 * @author Michel Kraemer
 */
public enum CSLLabel {
	BOOK("book"), CHAPTER("chapter"), COLUMN("column"), FIGURE("figure"), FOLIO(
			"folio"), ISSUE("issue"), LINE("line"), NOTE("note"), OPUS("opus"), PAGE(
			"page"), PARAGRAPH("paragraph"), PART("part"), SECTION("section"), SUB_VERBO(
			"sub_verbo"), VERSE("verse"), VOLUME("volume");

	private String name;

	private CSLLabel(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}
}
