// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.helper.JsonObject;

/**
 * A citation item contains all attributes that make up a citation.
 * 
 * @author Michel Kraemer
 */
public class CSLItemData implements JsonObject {
	private final String id;
	private final CSLType type;

	private final String[] categories;
	private final String language;
	private final String journalAbbreviation;
	private final String shortTitle;
	private final CSLName[] author;
	private final CSLName[] collectionEditor;
	private final CSLName[] composer;
	private final CSLName[] containerAuthor;
	private final CSLName[] director;
	private final CSLName[] editor;
	private final CSLName[] editorialDirector;
	private final CSLName[] interviewer;
	private final CSLName[] illustrator;
	private final CSLName[] originalAuthor;
	private final CSLName[] recipient;
	private final CSLName[] reviewedAuthor;
	private final CSLName[] translator;
	private final CSLDate accessed;
	private final CSLDate container;
	private final CSLDate eventDate;
	private final CSLDate issued;
	private final CSLDate originalDate;
	private final CSLDate submitted;
	private final String abstrct;
	private final String annote;
	private final String archive;
	private final String archiveLocation;
	private final String archivePlace;
	private final String authority;
	private final String callNumber;
	private final String chapterNumber;
	private final String citationNumber;
	private final String citationLabel;
	private final String collectionNumber;
	private final String collectionTitle;
	private final String containerTitle;
	private final String containerTitleShort;
	private final String dimensions;
	private final String DOI;
	private final String edition;
	private final String event;
	private final String eventplace;
	private final String firstReferenceNoteNumber;
	private final String genre;
	private final String ISBN;
	private final String ISSN;
	private final String issue;
	private final String jurisdiction;
	private final String keyword;
	private final String locator;
	private final String medium;
	private final String note;
	private final String number;
	private final String numberOfPages;
	private final String numberOfVolumes;
	private final String originalPublisher;
	private final String originalPublisherPlace;
	private final String originalTitle;
	private final String page;
	private final String pageFirst;
	private final String PMCID;
	private final String PMID;
	private final String publisher;
	private final String publisherPlace;
	private final String references;
	private final String reviewedTitle;
	private final String scale;
	private final String section;
	private final String source;
	private final String status;
	private final String title;
	private final String titleShort;
	private final String URL;
	private final String version;
	private final String volume;
	private final String yearSuffix;

	public CSLItemData(String id, CSLType type) {
		this.id = id;
		this.type = type;

		this.categories = null;
		this.language = null;
		this.journalAbbreviation = null;
		this.shortTitle = null;
		this.author = null;
		this.collectionEditor = null;
		this.composer = null;
		this.containerAuthor = null;
		this.director = null;
		this.editor = null;
		this.editorialDirector = null;
		this.interviewer = null;
		this.illustrator = null;
		this.originalAuthor = null;
		this.recipient = null;
		this.reviewedAuthor = null;
		this.translator = null;
		this.accessed = null;
		this.container = null;
		this.eventDate = null;
		this.issued = null;
		this.originalDate = null;
		this.submitted = null;
		this.abstrct = null;
		this.annote = null;
		this.archive = null;
		this.archiveLocation = null;
		this.archivePlace = null;
		this.authority = null;
		this.callNumber = null;
		this.chapterNumber = null;
		this.citationNumber = null;
		this.citationLabel = null;
		this.collectionNumber = null;
		this.collectionTitle = null;
		this.containerTitle = null;
		this.containerTitleShort = null;
		this.dimensions = null;
		this.DOI = null;
		this.edition = null;
		this.event = null;
		this.eventplace = null;
		this.firstReferenceNoteNumber = null;
		this.genre = null;
		this.ISBN = null;
		this.ISSN = null;
		this.issue = null;
		this.jurisdiction = null;
		this.keyword = null;
		this.locator = null;
		this.medium = null;
		this.note = null;
		this.number = null;
		this.numberOfPages = null;
		this.numberOfVolumes = null;
		this.originalPublisher = null;
		this.originalPublisherPlace = null;
		this.originalTitle = null;
		this.page = null;
		this.pageFirst = null;
		this.PMCID = null;
		this.PMID = null;
		this.publisher = null;
		this.publisherPlace = null;
		this.references = null;
		this.reviewedTitle = null;
		this.scale = null;
		this.section = null;
		this.source = null;
		this.status = null;
		this.title = null;
		this.titleShort = null;
		this.URL = null;
		this.version = null;
		this.volume = null;
		this.yearSuffix = null;

	}

	public CSLItemData(String id, CSLType type, String[] categories,
			String language, String journalAbbreviation, String shortTitle,
			CSLName[] author, CSLName[] collectionEditor, CSLName[] composer,
			CSLName[] containerAuthor, CSLName[] director, CSLName[] editor,
			CSLName[] editorialDirector, CSLName[] interviewer,
			CSLName[] illustrator, CSLName[] originalAuthor,
			CSLName[] recipient, CSLName[] reviewedAuthor,
			CSLName[] translator, CSLDate accessed, CSLDate container,
			CSLDate eventDate, CSLDate issued, CSLDate originalDate,
			CSLDate submitted, String abstrct, String annote, String archive,
			String archiveLocation, String archivePlace, String authority,
			String callNumber, String chapterNumber, String citationNumber,
			String citationLabel, String collectionNumber,
			String collectionTitle, String containerTitle,
			String containerTitleShort, String dimensions, String DOI,
			String edition, String event, String eventplace,
			String firstReferenceNoteNumber, String genre, String ISBN,
			String ISSN, String issue, String jurisdiction, String keyword,
			String locator, String medium, String note, String number,
			String numberOfPages, String numberOfVolumes,
			String originalPublisher, String originalPublisherPlace,
			String originalTitle, String page, String pageFirst, String PMCID,
			String PMID, String publisher, String publisherPlace,
			String references, String reviewedTitle, String scale,
			String section, String source, String status, String title,
			String titleShort, String URL, String version, String volume,
			String yearSuffix) {
		this.id = id;
		this.type = type;

		this.categories = categories;
		this.language = language;
		this.journalAbbreviation = journalAbbreviation;
		this.shortTitle = shortTitle;
		this.author = author;
		this.collectionEditor = collectionEditor;
		this.composer = composer;
		this.containerAuthor = containerAuthor;
		this.director = director;
		this.editor = editor;
		this.editorialDirector = editorialDirector;
		this.interviewer = interviewer;
		this.illustrator = illustrator;
		this.originalAuthor = originalAuthor;
		this.recipient = recipient;
		this.reviewedAuthor = reviewedAuthor;
		this.translator = translator;
		this.accessed = accessed;
		this.container = container;
		this.eventDate = eventDate;
		this.issued = issued;
		this.originalDate = originalDate;
		this.submitted = submitted;
		this.abstrct = abstrct;
		this.annote = annote;
		this.archive = archive;
		this.archiveLocation = archiveLocation;
		this.archivePlace = archivePlace;
		this.authority = authority;
		this.callNumber = callNumber;
		this.chapterNumber = chapterNumber;
		this.citationNumber = citationNumber;
		this.citationLabel = citationLabel;
		this.collectionNumber = collectionNumber;
		this.collectionTitle = collectionTitle;
		this.containerTitle = containerTitle;
		this.containerTitleShort = containerTitleShort;
		this.dimensions = dimensions;
		this.DOI = DOI;
		this.edition = edition;
		this.event = event;
		this.eventplace = eventplace;
		this.firstReferenceNoteNumber = firstReferenceNoteNumber;
		this.genre = genre;
		this.ISBN = ISBN;
		this.ISSN = ISSN;
		this.issue = issue;
		this.jurisdiction = jurisdiction;
		this.keyword = keyword;
		this.locator = locator;
		this.medium = medium;
		this.note = note;
		this.number = number;
		this.numberOfPages = numberOfPages;
		this.numberOfVolumes = numberOfVolumes;
		this.originalPublisher = originalPublisher;
		this.originalPublisherPlace = originalPublisherPlace;
		this.originalTitle = originalTitle;
		this.page = page;
		this.pageFirst = pageFirst;
		this.PMCID = PMCID;
		this.PMID = PMID;
		this.publisher = publisher;
		this.publisherPlace = publisherPlace;
		this.references = references;
		this.reviewedTitle = reviewedTitle;
		this.scale = scale;
		this.section = section;
		this.source = source;
		this.status = status;
		this.title = title;
		this.titleShort = titleShort;
		this.URL = URL;
		this.version = version;
		this.volume = volume;
		this.yearSuffix = yearSuffix;

	}

	/**
	 * @return the citation item's id
	 */
	public String getId() {
		return id;
	}
	/**
	 * @return the citation item's type
	 */
	public CSLType getType() {
		return type;
	}

	/**
	 * @return the citation item's categories
	 */
	public String[] getCategories() {
		return categories;
	}
	/**
	 * @return the citation item's language
	 */
	public String getLanguage() {
		return language;
	}
	/**
	 * @return the citation item's journalAbbreviation
	 */
	public String getJournalAbbreviation() {
		return journalAbbreviation;
	}
	/**
	 * @return the citation item's shortTitle
	 */
	public String getShortTitle() {
		return shortTitle;
	}
	/**
	 * @return the citation item's author
	 */
	public CSLName[] getAuthor() {
		return author;
	}
	/**
	 * @return the citation item's collection-editor
	 */
	public CSLName[] getCollectionEditor() {
		return collectionEditor;
	}
	/**
	 * @return the citation item's composer
	 */
	public CSLName[] getComposer() {
		return composer;
	}
	/**
	 * @return the citation item's container-author
	 */
	public CSLName[] getContainerAuthor() {
		return containerAuthor;
	}
	/**
	 * @return the citation item's director
	 */
	public CSLName[] getDirector() {
		return director;
	}
	/**
	 * @return the citation item's editor
	 */
	public CSLName[] getEditor() {
		return editor;
	}
	/**
	 * @return the citation item's editorial-director
	 */
	public CSLName[] getEditorialDirector() {
		return editorialDirector;
	}
	/**
	 * @return the citation item's interviewer
	 */
	public CSLName[] getInterviewer() {
		return interviewer;
	}
	/**
	 * @return the citation item's illustrator
	 */
	public CSLName[] getIllustrator() {
		return illustrator;
	}
	/**
	 * @return the citation item's original-author
	 */
	public CSLName[] getOriginalAuthor() {
		return originalAuthor;
	}
	/**
	 * @return the citation item's recipient
	 */
	public CSLName[] getRecipient() {
		return recipient;
	}
	/**
	 * @return the citation item's reviewed-author
	 */
	public CSLName[] getReviewedAuthor() {
		return reviewedAuthor;
	}
	/**
	 * @return the citation item's translator
	 */
	public CSLName[] getTranslator() {
		return translator;
	}
	/**
	 * @return the citation item's accessed
	 */
	public CSLDate getAccessed() {
		return accessed;
	}
	/**
	 * @return the citation item's container
	 */
	public CSLDate getContainer() {
		return container;
	}
	/**
	 * @return the citation item's event-date
	 */
	public CSLDate getEventDate() {
		return eventDate;
	}
	/**
	 * @return the citation item's issued
	 */
	public CSLDate getIssued() {
		return issued;
	}
	/**
	 * @return the citation item's original-date
	 */
	public CSLDate getOriginalDate() {
		return originalDate;
	}
	/**
	 * @return the citation item's submitted
	 */
	public CSLDate getSubmitted() {
		return submitted;
	}
	/**
	 * @return the citation item's abstract
	 */
	public String getAbstrct() {
		return abstrct;
	}
	/**
	 * @return the citation item's annote
	 */
	public String getAnnote() {
		return annote;
	}
	/**
	 * @return the citation item's archive
	 */
	public String getArchive() {
		return archive;
	}
	/**
	 * @return the citation item's archive_location
	 */
	public String getArchiveLocation() {
		return archiveLocation;
	}
	/**
	 * @return the citation item's archive-place
	 */
	public String getArchivePlace() {
		return archivePlace;
	}
	/**
	 * @return the citation item's authority
	 */
	public String getAuthority() {
		return authority;
	}
	/**
	 * @return the citation item's call-number
	 */
	public String getCallNumber() {
		return callNumber;
	}
	/**
	 * @return the citation item's chapter-number
	 */
	public String getChapterNumber() {
		return chapterNumber;
	}
	/**
	 * @return the citation item's citation-number
	 */
	public String getCitationNumber() {
		return citationNumber;
	}
	/**
	 * @return the citation item's citation-label
	 */
	public String getCitationLabel() {
		return citationLabel;
	}
	/**
	 * @return the citation item's collection-number
	 */
	public String getCollectionNumber() {
		return collectionNumber;
	}
	/**
	 * @return the citation item's collection-title
	 */
	public String getCollectionTitle() {
		return collectionTitle;
	}
	/**
	 * @return the citation item's container-title
	 */
	public String getContainerTitle() {
		return containerTitle;
	}
	/**
	 * @return the citation item's container-title-short
	 */
	public String getContainerTitleShort() {
		return containerTitleShort;
	}
	/**
	 * @return the citation item's dimensions
	 */
	public String getDimensions() {
		return dimensions;
	}
	/**
	 * @return the citation item's DOI
	 */
	public String getDOI() {
		return DOI;
	}
	/**
	 * @return the citation item's edition
	 */
	public String getEdition() {
		return edition;
	}
	/**
	 * @return the citation item's event
	 */
	public String getEvent() {
		return event;
	}
	/**
	 * @return the citation item's eventplace
	 */
	public String getEventplace() {
		return eventplace;
	}
	/**
	 * @return the citation item's first-reference-note-number
	 */
	public String getFirstReferenceNoteNumber() {
		return firstReferenceNoteNumber;
	}
	/**
	 * @return the citation item's genre
	 */
	public String getGenre() {
		return genre;
	}
	/**
	 * @return the citation item's ISBN
	 */
	public String getISBN() {
		return ISBN;
	}
	/**
	 * @return the citation item's ISSN
	 */
	public String getISSN() {
		return ISSN;
	}
	/**
	 * @return the citation item's issue
	 */
	public String getIssue() {
		return issue;
	}
	/**
	 * @return the citation item's jurisdiction
	 */
	public String getJurisdiction() {
		return jurisdiction;
	}
	/**
	 * @return the citation item's keyword
	 */
	public String getKeyword() {
		return keyword;
	}
	/**
	 * @return the citation item's locator
	 */
	public String getLocator() {
		return locator;
	}
	/**
	 * @return the citation item's medium
	 */
	public String getMedium() {
		return medium;
	}
	/**
	 * @return the citation item's note
	 */
	public String getNote() {
		return note;
	}
	/**
	 * @return the citation item's number
	 */
	public String getNumber() {
		return number;
	}
	/**
	 * @return the citation item's number-of-pages
	 */
	public String getNumberOfPages() {
		return numberOfPages;
	}
	/**
	 * @return the citation item's number-of-volumes
	 */
	public String getNumberOfVolumes() {
		return numberOfVolumes;
	}
	/**
	 * @return the citation item's original-publisher
	 */
	public String getOriginalPublisher() {
		return originalPublisher;
	}
	/**
	 * @return the citation item's original-publisher-place
	 */
	public String getOriginalPublisherPlace() {
		return originalPublisherPlace;
	}
	/**
	 * @return the citation item's original-title
	 */
	public String getOriginalTitle() {
		return originalTitle;
	}
	/**
	 * @return the citation item's page
	 */
	public String getPage() {
		return page;
	}
	/**
	 * @return the citation item's page-first
	 */
	public String getPageFirst() {
		return pageFirst;
	}
	/**
	 * @return the citation item's PMCID
	 */
	public String getPMCID() {
		return PMCID;
	}
	/**
	 * @return the citation item's PMID
	 */
	public String getPMID() {
		return PMID;
	}
	/**
	 * @return the citation item's publisher
	 */
	public String getPublisher() {
		return publisher;
	}
	/**
	 * @return the citation item's publisher-place
	 */
	public String getPublisherPlace() {
		return publisherPlace;
	}
	/**
	 * @return the citation item's references
	 */
	public String getReferences() {
		return references;
	}
	/**
	 * @return the citation item's reviewed-title
	 */
	public String getReviewedTitle() {
		return reviewedTitle;
	}
	/**
	 * @return the citation item's scale
	 */
	public String getScale() {
		return scale;
	}
	/**
	 * @return the citation item's section
	 */
	public String getSection() {
		return section;
	}
	/**
	 * @return the citation item's source
	 */
	public String getSource() {
		return source;
	}
	/**
	 * @return the citation item's status
	 */
	public String getStatus() {
		return status;
	}
	/**
	 * @return the citation item's title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @return the citation item's title-short
	 */
	public String getTitleShort() {
		return titleShort;
	}
	/**
	 * @return the citation item's URL
	 */
	public String getURL() {
		return URL;
	}
	/**
	 * @return the citation item's version
	 */
	public String getVersion() {
		return version;
	}
	/**
	 * @return the citation item's volume
	 */
	public String getVolume() {
		return volume;
	}
	/**
	 * @return the citation item's year-suffix
	 */
	public String getYearSuffix() {
		return yearSuffix;
	}

	@Override
	public String toJson() {
		StringBuilder r = new StringBuilder("{");
		r.append("\"id\": " + JsonHelper.toJson(id));
		r.append(",");
		r.append("\"type\": " + JsonHelper.toJson(type));

		if (categories != null) {
			r.append(",\"categories\": " + JsonHelper.toJson(categories));
		}
		if (language != null) {
			r.append(",\"language\": " + JsonHelper.toJson(language));
		}
		if (journalAbbreviation != null) {
			r.append(",\"journalAbbreviation\": "
					+ JsonHelper.toJson(journalAbbreviation));
		}
		if (shortTitle != null) {
			r.append(",\"shortTitle\": " + JsonHelper.toJson(shortTitle));
		}
		if (author != null) {
			r.append(",\"author\": " + JsonHelper.toJson(author));
		}
		if (collectionEditor != null) {
			r.append(",\"collection-editor\": "
					+ JsonHelper.toJson(collectionEditor));
		}
		if (composer != null) {
			r.append(",\"composer\": " + JsonHelper.toJson(composer));
		}
		if (containerAuthor != null) {
			r.append(",\"container-author\": "
					+ JsonHelper.toJson(containerAuthor));
		}
		if (director != null) {
			r.append(",\"director\": " + JsonHelper.toJson(director));
		}
		if (editor != null) {
			r.append(",\"editor\": " + JsonHelper.toJson(editor));
		}
		if (editorialDirector != null) {
			r.append(",\"editorial-director\": "
					+ JsonHelper.toJson(editorialDirector));
		}
		if (interviewer != null) {
			r.append(",\"interviewer\": " + JsonHelper.toJson(interviewer));
		}
		if (illustrator != null) {
			r.append(",\"illustrator\": " + JsonHelper.toJson(illustrator));
		}
		if (originalAuthor != null) {
			r.append(",\"original-author\": "
					+ JsonHelper.toJson(originalAuthor));
		}
		if (recipient != null) {
			r.append(",\"recipient\": " + JsonHelper.toJson(recipient));
		}
		if (reviewedAuthor != null) {
			r.append(",\"reviewed-author\": "
					+ JsonHelper.toJson(reviewedAuthor));
		}
		if (translator != null) {
			r.append(",\"translator\": " + JsonHelper.toJson(translator));
		}
		if (accessed != null) {
			r.append(",\"accessed\": " + JsonHelper.toJson(accessed));
		}
		if (container != null) {
			r.append(",\"container\": " + JsonHelper.toJson(container));
		}
		if (eventDate != null) {
			r.append(",\"event-date\": " + JsonHelper.toJson(eventDate));
		}
		if (issued != null) {
			r.append(",\"issued\": " + JsonHelper.toJson(issued));
		}
		if (originalDate != null) {
			r.append(",\"original-date\": " + JsonHelper.toJson(originalDate));
		}
		if (submitted != null) {
			r.append(",\"submitted\": " + JsonHelper.toJson(submitted));
		}
		if (abstrct != null) {
			r.append(",\"abstract\": " + JsonHelper.toJson(abstrct));
		}
		if (annote != null) {
			r.append(",\"annote\": " + JsonHelper.toJson(annote));
		}
		if (archive != null) {
			r.append(",\"archive\": " + JsonHelper.toJson(archive));
		}
		if (archiveLocation != null) {
			r.append(",\"archive_location\": "
					+ JsonHelper.toJson(archiveLocation));
		}
		if (archivePlace != null) {
			r.append(",\"archive-place\": " + JsonHelper.toJson(archivePlace));
		}
		if (authority != null) {
			r.append(",\"authority\": " + JsonHelper.toJson(authority));
		}
		if (callNumber != null) {
			r.append(",\"call-number\": " + JsonHelper.toJson(callNumber));
		}
		if (chapterNumber != null) {
			r.append(",\"chapter-number\": " + JsonHelper.toJson(chapterNumber));
		}
		if (citationNumber != null) {
			r.append(",\"citation-number\": "
					+ JsonHelper.toJson(citationNumber));
		}
		if (citationLabel != null) {
			r.append(",\"citation-label\": " + JsonHelper.toJson(citationLabel));
		}
		if (collectionNumber != null) {
			r.append(",\"collection-number\": "
					+ JsonHelper.toJson(collectionNumber));
		}
		if (collectionTitle != null) {
			r.append(",\"collection-title\": "
					+ JsonHelper.toJson(collectionTitle));
		}
		if (containerTitle != null) {
			r.append(",\"container-title\": "
					+ JsonHelper.toJson(containerTitle));
		}
		if (containerTitleShort != null) {
			r.append(",\"container-title-short\": "
					+ JsonHelper.toJson(containerTitleShort));
		}
		if (dimensions != null) {
			r.append(",\"dimensions\": " + JsonHelper.toJson(dimensions));
		}
		if (DOI != null) {
			r.append(",\"DOI\": " + JsonHelper.toJson(DOI));
		}
		if (edition != null) {
			r.append(",\"edition\": " + JsonHelper.toJson(edition));
		}
		if (event != null) {
			r.append(",\"event\": " + JsonHelper.toJson(event));
		}
		if (eventplace != null) {
			r.append(",\"eventplace\": " + JsonHelper.toJson(eventplace));
		}
		if (firstReferenceNoteNumber != null) {
			r.append(",\"first-reference-note-number\": "
					+ JsonHelper.toJson(firstReferenceNoteNumber));
		}
		if (genre != null) {
			r.append(",\"genre\": " + JsonHelper.toJson(genre));
		}
		if (ISBN != null) {
			r.append(",\"ISBN\": " + JsonHelper.toJson(ISBN));
		}
		if (ISSN != null) {
			r.append(",\"ISSN\": " + JsonHelper.toJson(ISSN));
		}
		if (issue != null) {
			r.append(",\"issue\": " + JsonHelper.toJson(issue));
		}
		if (jurisdiction != null) {
			r.append(",\"jurisdiction\": " + JsonHelper.toJson(jurisdiction));
		}
		if (keyword != null) {
			r.append(",\"keyword\": " + JsonHelper.toJson(keyword));
		}
		if (locator != null) {
			r.append(",\"locator\": " + JsonHelper.toJson(locator));
		}
		if (medium != null) {
			r.append(",\"medium\": " + JsonHelper.toJson(medium));
		}
		if (note != null) {
			r.append(",\"note\": " + JsonHelper.toJson(note));
		}
		if (number != null) {
			r.append(",\"number\": " + JsonHelper.toJson(number));
		}
		if (numberOfPages != null) {
			r.append(",\"number-of-pages\": "
					+ JsonHelper.toJson(numberOfPages));
		}
		if (numberOfVolumes != null) {
			r.append(",\"number-of-volumes\": "
					+ JsonHelper.toJson(numberOfVolumes));
		}
		if (originalPublisher != null) {
			r.append(",\"original-publisher\": "
					+ JsonHelper.toJson(originalPublisher));
		}
		if (originalPublisherPlace != null) {
			r.append(",\"original-publisher-place\": "
					+ JsonHelper.toJson(originalPublisherPlace));
		}
		if (originalTitle != null) {
			r.append(",\"original-title\": " + JsonHelper.toJson(originalTitle));
		}
		if (page != null) {
			r.append(",\"page\": " + JsonHelper.toJson(page));
		}
		if (pageFirst != null) {
			r.append(",\"page-first\": " + JsonHelper.toJson(pageFirst));
		}
		if (PMCID != null) {
			r.append(",\"PMCID\": " + JsonHelper.toJson(PMCID));
		}
		if (PMID != null) {
			r.append(",\"PMID\": " + JsonHelper.toJson(PMID));
		}
		if (publisher != null) {
			r.append(",\"publisher\": " + JsonHelper.toJson(publisher));
		}
		if (publisherPlace != null) {
			r.append(",\"publisher-place\": "
					+ JsonHelper.toJson(publisherPlace));
		}
		if (references != null) {
			r.append(",\"references\": " + JsonHelper.toJson(references));
		}
		if (reviewedTitle != null) {
			r.append(",\"reviewed-title\": " + JsonHelper.toJson(reviewedTitle));
		}
		if (scale != null) {
			r.append(",\"scale\": " + JsonHelper.toJson(scale));
		}
		if (section != null) {
			r.append(",\"section\": " + JsonHelper.toJson(section));
		}
		if (source != null) {
			r.append(",\"source\": " + JsonHelper.toJson(source));
		}
		if (status != null) {
			r.append(",\"status\": " + JsonHelper.toJson(status));
		}
		if (title != null) {
			r.append(",\"title\": " + JsonHelper.toJson(title));
		}
		if (titleShort != null) {
			r.append(",\"title-short\": " + JsonHelper.toJson(titleShort));
		}
		if (URL != null) {
			r.append(",\"URL\": " + JsonHelper.toJson(URL));
		}
		if (version != null) {
			r.append(",\"version\": " + JsonHelper.toJson(version));
		}
		if (volume != null) {
			r.append(",\"volume\": " + JsonHelper.toJson(volume));
		}
		if (yearSuffix != null) {
			r.append(",\"year-suffix\": " + JsonHelper.toJson(yearSuffix));
		}

		r.append("}");
		return r.toString();
	}

	@Override
	public String toString() {
		return toJson();
	}

}
