// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Builder for {@link CSLDate}
 * 
 * @author Michel Kraemer
 */
public class CSLDateBuilder {
	private int[][] dateParts;
	private String season;
	private Boolean circa;
	private String literal;
	private String raw;

	public CSLDateBuilder() {
		this.dateParts = null;
		this.season = null;
		this.circa = null;
		this.literal = null;
		this.raw = null;

	}

	public CSLDateBuilder dateParts(int[]... dateParts) {
		this.dateParts = dateParts;
		return this;
	}
	public CSLDateBuilder season(String season) {
		this.season = season;
		return this;
	}
	public CSLDateBuilder circa(Boolean circa) {
		this.circa = circa;
		return this;
	}
	public CSLDateBuilder literal(String literal) {
		this.literal = literal;
		return this;
	}
	public CSLDateBuilder raw(String raw) {
		this.raw = raw;
		return this;
	}

	public CSLDate build() {
		return new CSLDate(dateParts, season, circa, literal, raw);
	}

	public CSLDateBuilder dateParts(int year) {
		dateParts(new int[]{year});
		return this;
	}
	public CSLDateBuilder dateParts(int year, int month) {
		dateParts(new int[]{year, month});
		return this;
	}
	public CSLDateBuilder dateParts(int year, int month, int day) {
		dateParts(new int[]{year, month, day});
		return this;
	}
	public CSLDateBuilder season(int season) {
		season(String.valueOf(season));
		return this;
	}
}
