// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.helper.JsonHelper;
import de.undercouch.citeproc.helper.JsonObject;

/**
 * A citation date.
 * 
 * @author Michel Kraemer
 */
public class CSLDate implements JsonObject {
	private final int[][] dateParts;
	private final String season;
	private final Boolean circa;
	private final String literal;
	private final String raw;

	public CSLDate() {
		this.dateParts = null;
		this.season = null;
		this.circa = null;
		this.literal = null;
		this.raw = null;

	}

	public CSLDate(int[][] dateParts, String season, Boolean circa,
			String literal, String raw) {
		this.dateParts = dateParts;
		this.season = season;
		this.circa = circa;
		this.literal = literal;
		this.raw = raw;

	}

	/**
	 * @return the date's date-parts
	 */
	public int[][] getDateParts() {
		return dateParts;
	}
	/**
	 * @return the date's season
	 */
	public String getSeason() {
		return season;
	}
	/**
	 * @return the date's circa
	 */
	public Boolean getCirca() {
		return circa;
	}
	/**
	 * @return the date's literal
	 */
	public String getLiteral() {
		return literal;
	}
	/**
	 * @return the date's raw
	 */
	public String getRaw() {
		return raw;
	}

	@Override
	public String toJson() {
		StringBuilder r = new StringBuilder("{");
		if (dateParts != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"date-parts\": " + JsonHelper.toJson(dateParts));
		}
		if (season != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"season\": " + JsonHelper.toJson(season));
		}
		if (circa != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"circa\": " + JsonHelper.toJson(circa));
		}
		if (literal != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"literal\": " + JsonHelper.toJson(literal));
		}
		if (raw != null) {
			if (r.length() > 1)
				r.append(",");
			r.append("\"raw\": " + JsonHelper.toJson(raw));
		}

		r.append("}");
		return r.toString();
	}

	@Override
	public String toString() {
		return toJson();
	}

}
