// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Builder for {@link CSLCitationItem}
 * 
 * @author Michel Kraemer
 */
public class CSLCitationItemBuilder {
	private String id;

	private CSLItemData itemData;
	private String prefix;
	private String suffix;
	private String locator;
	private CSLLabel label;
	private Boolean suppressAuthor;
	private Boolean authorOnly;
	private String[] uris;

	public CSLCitationItemBuilder(String id) {
		this.id = id;

		this.itemData = null;
		this.prefix = null;
		this.suffix = null;
		this.locator = null;
		this.label = null;
		this.suppressAuthor = null;
		this.authorOnly = null;
		this.uris = null;

	}

	public CSLCitationItemBuilder itemData(CSLItemData itemData) {
		this.itemData = itemData;
		return this;
	}
	public CSLCitationItemBuilder prefix(String prefix) {
		this.prefix = prefix;
		return this;
	}
	public CSLCitationItemBuilder suffix(String suffix) {
		this.suffix = suffix;
		return this;
	}
	public CSLCitationItemBuilder locator(String locator) {
		this.locator = locator;
		return this;
	}
	public CSLCitationItemBuilder label(CSLLabel label) {
		this.label = label;
		return this;
	}
	public CSLCitationItemBuilder suppressAuthor(Boolean suppressAuthor) {
		this.suppressAuthor = suppressAuthor;
		return this;
	}
	public CSLCitationItemBuilder authorOnly(Boolean authorOnly) {
		this.authorOnly = authorOnly;
		return this;
	}
	public CSLCitationItemBuilder uris(String... uris) {
		this.uris = uris;
		return this;
	}

	public CSLCitationItem build() {
		return new CSLCitationItem(id, itemData, prefix, suffix, locator,
				label, suppressAuthor, authorOnly, uris);
	}

}
