/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.uuid;

import de.undercouch.bson4jackson.BsonGenerator;
import java.io.IOException;
import java.util.UUID;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class BsonUuidSerializer
extends JsonSerializer<UUID> {
    public void serialize(UUID value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!(jgen instanceof BsonGenerator)) {
            throw new JsonGenerationException("BsonUuidSerializer can only be used with BsonGenerator");
        }
        ((BsonGenerator)jgen).writeBinary(null, (byte)3, BsonUuidSerializer.uuidToLittleEndianBytes(value), 0, 16);
    }

    private static byte[] uuidToLittleEndianBytes(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * i);
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (i - 16));
        }
        return buffer;
    }
}

