/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.actson;

import de.undercouch.actson.DefaultJsonFeeder;
import de.undercouch.actson.JsonFeeder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class JsonParser {
    private static final int __ = -1;
    private static final int C_SPACE = 0;
    private static final int C_WHITE = 1;
    private static final int C_LCURB = 2;
    private static final int C_RCURB = 3;
    private static final int C_LSQRB = 4;
    private static final int C_RSQRB = 5;
    private static final int C_COLON = 6;
    private static final int C_COMMA = 7;
    private static final int C_QUOTE = 8;
    private static final int C_BACKS = 9;
    private static final int C_SLASH = 10;
    private static final int C_PLUS = 11;
    private static final int C_MINUS = 12;
    private static final int C_POINT = 13;
    private static final int C_ZERO = 14;
    private static final int C_DIGIT = 15;
    private static final int C_LOW_A = 16;
    private static final int C_LOW_B = 17;
    private static final int C_LOW_C = 18;
    private static final int C_LOW_D = 19;
    private static final int C_LOW_E = 20;
    private static final int C_LOW_F = 21;
    private static final int C_LOW_L = 22;
    private static final int C_LOW_N = 23;
    private static final int C_LOW_R = 24;
    private static final int C_LOW_S = 25;
    private static final int C_LOW_T = 26;
    private static final int C_LOW_U = 27;
    private static final int C_ABCDF = 28;
    private static final int C_E = 29;
    private static final int C_ETC = 30;
    private static final int[] ascii_class = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 30, 8, 30, 30, 30, 30, 30, 30, 30, 30, 11, 7, 12, 13, 10, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 6, 30, 30, 30, 30, 30, 30, 28, 28, 28, 28, 29, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 4, 9, 5, 30, 30, 30, 16, 17, 18, 19, 20, 21, 30, 30, 30, 30, 30, 22, 30, 23, 30, 30, 30, 24, 25, 26, 27, 30, 30, 30, 30, 30, 2, 30, 3, 30, 30};
    private static final int GO = 0;
    private static final int OK = 1;
    private static final int OB = 2;
    private static final int KE = 3;
    private static final int CO = 4;
    private static final int VA = 5;
    private static final int AR = 6;
    private static final int ST = 7;
    private static final int ES = 8;
    private static final int U1 = 9;
    private static final int U2 = 10;
    private static final int U3 = 11;
    private static final int U4 = 12;
    private static final int MI = 13;
    private static final int ZE = 14;
    private static final int IN = 15;
    private static final int FR = 16;
    private static final int E1 = 17;
    private static final int E2 = 18;
    private static final int E3 = 19;
    private static final int T1 = 20;
    private static final int T2 = 21;
    private static final int T3 = 22;
    private static final int F1 = 23;
    private static final int F2 = 24;
    private static final int F3 = 25;
    private static final int F4 = 26;
    private static final int N1 = 27;
    private static final int N2 = 28;
    private static final int N3 = 29;
    private static int[][] state_transition_table = new int[][]{{0, 0, -6, -1, -5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 2, -1, -9, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 3, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 4, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {5, 5, -6, -1, -5, -1, -1, -1, 7, -1, -1, -1, 13, -1, 14, 15, -1, -1, -1, -1, -1, 23, -1, 27, -1, -1, 20, -1, -1, -1, -1}, {6, 6, -6, -1, -5, -7, -1, -1, 7, -1, -1, -1, 13, -1, 14, 15, -1, -1, -1, -1, -1, 23, -1, 27, -1, -1, 20, -1, -1, -1, -1}, {7, -1, 7, 7, 7, 7, 7, 7, -4, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {-1, -1, -1, -1, -1, -1, -1, -1, 7, 7, 7, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, 7, -1, 7, 7, -1, 7, 9, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, -1, -1, -1, -1, 10, 10, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, -1, -1, 11, 11, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 12, 12, 12, 12, 12, 12, 12, -1, -1, -1, -1, -1, -1, 12, 12, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, 7, 7, 7, 7, 7, 7, 7, -1, -1, -1, -1, -1, -1, 7, 7, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, 16, 15, 15, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, 16, 16, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18, 18, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 21, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 25, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int MODE_ARRAY = 0;
    private static final int MODE_DONE = 1;
    private static final int MODE_KEY = 2;
    private static final int MODE_OBJECT = 3;
    private int[] stack = new int[16];
    private int top = -1;
    private int depth = 2048;
    private int state = 0;
    private StringBuilder currentValue;
    private int parsedCharacterCount = 0;
    private final JsonFeeder feeder;
    private int event1 = 0;
    private int event2 = 0;

    private boolean push(int mode) {
        ++this.top;
        if (this.top >= this.stack.length) {
            if (this.top >= this.depth) {
                return false;
            }
            this.stack = Arrays.copyOf(this.stack, Math.min(this.stack.length * 2, this.depth));
        }
        this.stack[this.top] = mode;
        return true;
    }

    private boolean pop(int mode) {
        if (this.top < 0 || this.stack[this.top] != mode) {
            return false;
        }
        --this.top;
        return true;
    }

    public JsonParser() {
        this(StandardCharsets.UTF_8);
    }

    public JsonParser(Charset charset) {
        this(new DefaultJsonFeeder(charset));
    }

    public JsonParser(JsonFeeder feeder) {
        this.push(1);
        this.feeder = feeder;
    }

    public void setMaxDepth(int depth) {
        this.depth = depth;
    }

    public int getMaxDepth() {
        return this.depth;
    }

    public int nextEvent() {
        try {
            while (this.event1 == 0) {
                if (!this.feeder.hasInput()) {
                    if (this.feeder.isDone()) {
                        return this.state == 1 && this.pop(1) ? 99 : -1;
                    }
                    return 0;
                }
                this.parse(this.feeder.nextInput());
            }
        }
        catch (CharacterCodingException e) {
            return -1;
        }
        int r = this.event1;
        if (this.event1 != -1) {
            this.event1 = this.event2;
            this.event2 = 0;
        }
        return r;
    }

    public JsonFeeder getFeeder() {
        return this.feeder;
    }

    private void parse(char nextChar) {
        int nextClass;
        ++this.parsedCharacterCount;
        if (nextChar >= '\u0080') {
            nextClass = 30;
        } else {
            nextClass = ascii_class[nextChar];
            if (nextClass <= -1) {
                this.event1 = -1;
                return;
            }
        }
        int nextState = state_transition_table[this.state][nextClass];
        if (nextState >= 0) {
            if (nextState >= 7 && nextState <= 19) {
                if (this.state < 7 || this.state > 19) {
                    this.currentValue = new StringBuilder();
                    if (nextState != 7) {
                        this.currentValue.append(nextChar);
                    }
                } else {
                    this.currentValue.append(nextChar);
                }
            } else if (nextState == 1) {
                this.event1 = this.stateToEvent();
            }
            this.state = nextState;
        } else {
            block0 : switch (nextState) {
                case -9: {
                    if (!this.pop(2)) {
                        this.event1 = -1;
                        return;
                    }
                    this.state = 1;
                    this.event1 = 2;
                    break;
                }
                case -8: {
                    if (!this.pop(3)) {
                        this.event1 = -1;
                        return;
                    }
                    this.state = 1;
                    this.event1 = 2;
                    break;
                }
                case -7: {
                    if (!this.pop(0)) {
                        this.event1 = -1;
                        return;
                    }
                    this.event1 = this.stateToEvent();
                    if (this.event1 == 0) {
                        this.event1 = 4;
                    } else {
                        this.event2 = 4;
                    }
                    this.state = 1;
                    break;
                }
                case -6: {
                    if (!this.push(2)) {
                        this.event1 = -1;
                        return;
                    }
                    this.state = 2;
                    this.event1 = 1;
                    break;
                }
                case -5: {
                    if (!this.push(0)) {
                        this.event1 = -1;
                        return;
                    }
                    this.state = 6;
                    this.event1 = 3;
                    break;
                }
                case -4: {
                    switch (this.stack[this.top]) {
                        case 2: {
                            this.state = 4;
                            this.event1 = 5;
                            break block0;
                        }
                        case 0: 
                        case 3: {
                            this.state = 1;
                            this.event1 = 6;
                            break block0;
                        }
                    }
                    this.event1 = -1;
                    return;
                }
                case -3: {
                    switch (this.stack[this.top]) {
                        case 3: {
                            if (!this.pop(3) || !this.push(2)) {
                                this.event1 = -1;
                                return;
                            }
                            this.event1 = this.stateToEvent();
                            this.state = 3;
                            break block0;
                        }
                        case 0: {
                            this.event1 = this.stateToEvent();
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.event1 = -1;
                    return;
                }
                case -2: {
                    if (!this.pop(2) || !this.push(3)) {
                        this.event1 = -1;
                        return;
                    }
                    this.state = 5;
                    break;
                }
                default: {
                    this.event1 = -1;
                    return;
                }
            }
        }
    }

    private int stateToEvent() {
        if (this.state == 15 || this.state == 14) {
            return 7;
        }
        if (this.state == 16 || this.state == 17 || this.state == 18 || this.state == 19) {
            return 8;
        }
        if (this.state == 22) {
            return 9;
        }
        if (this.state == 26) {
            return 10;
        }
        if (this.state == 29) {
            return 11;
        }
        return 0;
    }

    public String getCurrentString() {
        return this.currentValue.toString();
    }

    public int getCurrentInt() {
        return Integer.parseInt(this.currentValue.toString());
    }

    public double getCurrentDouble() {
        return Double.parseDouble(this.currentValue.toString());
    }

    public int getParsedCharacterCount() {
        return this.parsedCharacterCount;
    }
}

