/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm.scrobble;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IgnoredMessageCode {
    ARTIST_IGNORED(1),
    TRACK_IGNORED(2),
    TIMESTAMP_TOO_OLD(3),
    TIMESTAMP_TOO_NEW(4),
    DAILY_SCROBBLE_LIMIT_EXCEEDED(5);

    private int codeId;
    private static Map<Integer, IgnoredMessageCode> idToCodeMap;

    private IgnoredMessageCode(int code) {
        this.codeId = code;
    }

    public static IgnoredMessageCode valueOfCode(int code) {
        IgnoredMessageCode messageCode = idToCodeMap.get(code);
        if (messageCode != null) {
            return messageCode;
        }
        throw new IllegalArgumentException("No IgnoredMessageCode for code " + code);
    }

    private int getCodeId() {
        return this.codeId;
    }

    static {
        idToCodeMap = new HashMap<Integer, IgnoredMessageCode>();
        for (IgnoredMessageCode code : IgnoredMessageCode.values()) {
            idToCodeMap.put(code.getCodeId(), code);
        }
    }
}

