/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Caller;
import de.umass.lastfm.Event;
import de.umass.lastfm.ImageHolder;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.util.MapUtilities;
import de.umass.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Venue
extends ImageHolder {
    static final ItemFactory<Venue> FACTORY = new VenueFactory();
    private String name;
    private String url;
    private String website;
    private String city;
    private String country;
    private String street;
    private String postal;
    private String phonenumber;
    private float latitude;
    private float longitude;
    private String timezone;
    private String id;

    private Venue() {
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.name;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getStreet() {
        return this.street;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getPhonenumber() {
        return this.phonenumber;
    }

    public static Collection<Venue> search(String venue, String apiKey) {
        return Venue.search(venue, null, apiKey);
    }

    public static Collection<Venue> search(String venue, String country, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venue", venue);
        MapUtilities.nullSafePut(params, "country", country);
        Result result = Caller.getInstance().call("venue.search", apiKey, params);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement child = result.getContentElement().getChild("venuematches");
        return ResponseBuilder.buildCollection(child, Venue.class);
    }

    public static Collection<Event> getEvents(String venueId, String apiKey) {
        return Venue.getEvents(venueId, false, apiKey);
    }

    public static Collection<Event> getEvents(String venueId, boolean festivalsOnly, String apiKey) {
        Result result = Caller.getInstance().call("venue.getEvents", apiKey, "venue", venueId, "festivalsonly", festivalsOnly ? "1" : "0");
        return ResponseBuilder.buildCollection(result, Event.class);
    }

    public static PaginatedResult<Event> getPastEvents(String venueId, String apiKey) {
        return Venue.getPastEvents(venueId, false, -1, -1, apiKey);
    }

    public static PaginatedResult<Event> getPastEvents(String venueId, boolean festivalsOnly, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venue", venueId);
        params.put("festivalsonly", festivalsOnly ? "1" : "0");
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("venue.getPastEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VenueFactory
    implements ItemFactory<Venue> {
        private VenueFactory() {
        }

        @Override
        public Venue createItemFromElement(DomElement element) {
            Venue venue = new Venue();
            venue.id = element.getChildText("id");
            venue.name = element.getChildText("name");
            venue.url = element.getChildText("url");
            venue.phonenumber = element.getChildText("phonenumber");
            venue.website = element.getChildText("website");
            ImageHolder.loadImages(venue, element);
            DomElement l = element.getChild("location");
            venue.city = l.getChildText("city");
            venue.country = l.getChildText("country");
            venue.street = l.getChildText("street");
            venue.postal = l.getChildText("postalcode");
            venue.timezone = l.getChildText("timezone");
            DomElement p = l.getChild("geo:point");
            if (p.getChildText("geo:lat").length() != 0) {
                venue.latitude = Float.parseFloat(p.getChildText("geo:lat"));
                venue.longitude = Float.parseFloat(p.getChildText("geo:long"));
            }
            return venue;
        }
    }
}

