/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Artist;
import de.umass.lastfm.Caller;
import de.umass.lastfm.Chart;
import de.umass.lastfm.Event;
import de.umass.lastfm.ImageHolder;
import de.umass.lastfm.ImageSize;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.MusicEntry;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.Period;
import de.umass.lastfm.Playlist;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Shout;
import de.umass.lastfm.Tag;
import de.umass.lastfm.Track;
import de.umass.util.MapUtilities;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends ImageHolder {
    static final ItemFactory<User> FACTORY = new UserFactory();
    private String id;
    private String name;
    private String url;
    private String realname;
    private String language;
    private String country;
    private int age = -1;
    private String gender;
    private boolean subscriber;
    private int numPlaylists;
    private int playcount;
    private Date registeredDate;

    private User(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getRealname() {
        return this.realname;
    }

    public String getUrl() {
        return this.url;
    }

    public int getAge() {
        return this.age;
    }

    public String getCountry() {
        return this.country;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getNumPlaylists() {
        return this.numPlaylists;
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public boolean isSubscriber() {
        return this.subscriber;
    }

    public String getImageURL() {
        return this.getImageURL(ImageSize.MEDIUM);
    }

    public String getId() {
        return this.id;
    }

    public Date getRegisteredDate() {
        return this.registeredDate;
    }

    public static PaginatedResult<Track> getArtistTracks(String user, String artist, String apiKey) {
        return User.getArtistTracks(user, artist, 1, 0L, 0L, apiKey);
    }

    public static PaginatedResult<Track> getArtistTracks(String user, String artist, int page, long startTimestamp, long endTimestamp, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("artist", artist);
        params.put("page", String.valueOf(page));
        params.put("startTimestamp", String.valueOf(startTimestamp));
        params.put("endTimestamp", String.valueOf(endTimestamp));
        Result result = Caller.getInstance().call("user.getArtistTracks", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static PaginatedResult<User> getFriends(String user, String apiKey) {
        return User.getFriends(user, false, 1, 50, apiKey);
    }

    public static PaginatedResult<User> getFriends(String user, boolean recenttracks, int page, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getFriends", apiKey, "user", user, "recenttracks", String.valueOf(recenttracks ? 1 : 0), "limit", String.valueOf(limit), "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, User.class);
    }

    public static Collection<User> getNeighbours(String user, String apiKey) {
        return User.getNeighbours(user, 100, apiKey);
    }

    public static Collection<User> getNeighbours(String user, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getNeighbours", apiKey, "user", user, "limit", String.valueOf(limit));
        return ResponseBuilder.buildCollection(result, User.class);
    }

    public static PaginatedResult<Track> getRecentTracks(String user, String apiKey) {
        return User.getRecentTracks(user, 1, 10, apiKey);
    }

    public static PaginatedResult<Track> getRecentTracks(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("limit", String.valueOf(limit));
        params.put("page", String.valueOf(page));
        Result result = Caller.getInstance().call("user.getRecentTracks", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static Collection<Album> getTopAlbums(String user, String apiKey) {
        return User.getTopAlbums(user, Period.OVERALL, apiKey);
    }

    public static Collection<Album> getTopAlbums(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopAlbums", apiKey, "user", user, "period", period.getString());
        return ResponseBuilder.buildCollection(result, Album.class);
    }

    public static Collection<Artist> getTopArtists(String user, String apiKey) {
        return User.getTopArtists(user, Period.OVERALL, apiKey);
    }

    public static Collection<Artist> getTopArtists(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopArtists", apiKey, "user", user, "period", period.getString());
        return ResponseBuilder.buildCollection(result, Artist.class);
    }

    public static Collection<Track> getTopTracks(String user, String apiKey) {
        return User.getTopTracks(user, Period.OVERALL, apiKey);
    }

    public static Collection<Track> getTopTracks(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopTracks", apiKey, "user", user, "period", period.getString());
        return ResponseBuilder.buildCollection(result, Track.class);
    }

    public static Collection<Tag> getTopTags(String user, String apiKey) {
        return User.getTopTags(user, -1, apiKey);
    }

    public static Collection<Tag> getTopTags(String user, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("user.getTopTags", apiKey, params);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, String apiKey) {
        return User.getWeeklyAlbumChart(user, null, null, -1, apiKey);
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, int limit, String apiKey) {
        return User.getWeeklyAlbumChart(user, null, null, limit, apiKey);
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyAlbumChart", "user", user, "album", from, to, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, String apiKey) {
        return User.getWeeklyArtistChart(user, null, null, -1, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, int limit, String apiKey) {
        return User.getWeeklyArtistChart(user, null, null, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyArtistChart", "user", user, "artist", from, to, limit, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, String apiKey) {
        return User.getWeeklyTrackChart(user, null, null, -1, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, int limit, String apiKey) {
        return User.getWeeklyTrackChart(user, null, null, limit, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyTrackChart", "user", user, "track", from, to, limit, apiKey);
    }

    public static LinkedHashMap<String, String> getWeeklyChartList(String user, String apiKey) {
        return Chart.getWeeklyChartList("user.getWeeklyChartList", "user", user, apiKey);
    }

    public static Collection<Chart> getWeeklyChartListAsCharts(String user, String apiKey) {
        return Chart.getWeeklyChartListAsCharts("user", user, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String user, String apiKey) {
        return User.getEvents(user, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String user, int page, String apiKey) {
        return User.getEvents(user, false, page, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String user, boolean festivalsOnly, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        MapUtilities.nullSafePut(params, "user", user);
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        if (festivalsOnly) {
            params.put("festivalsonly", "1");
        }
        Result result = Caller.getInstance().call("user.getEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Event> getPastEvents(String user, String apiKey) {
        return User.getPastEvents(user, -1, apiKey);
    }

    public static PaginatedResult<Event> getPastEvents(String user, int page, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("user.getPastEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Event> getRecommendedEvents(Session session) {
        return User.getRecommendedEvents(1, session);
    }

    public static PaginatedResult<Event> getRecommendedEvents(int page, Session session) {
        Result result = Caller.getInstance().call("user.getRecommendedEvents", session, "page", String.valueOf(page), "user", session.getUsername());
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static Collection<Playlist> getPlaylists(String user, String apiKey) {
        Result result = Caller.getInstance().call("user.getPlaylists", apiKey, "user", user);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Playlist> playlists = new ArrayList<Playlist>();
        for (DomElement element : result.getContentElement().getChildren("playlist")) {
            playlists.add(ResponseBuilder.buildItem(element, Playlist.class));
        }
        return playlists;
    }

    public static PaginatedResult<Track> getLovedTracks(String user, String apiKey) {
        return User.getLovedTracks(user, 1, apiKey);
    }

    public static PaginatedResult<Track> getLovedTracks(String user, int page, String apiKey) {
        Result result = Caller.getInstance().call("user.getLovedTracks", apiKey, "user", user, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static User getInfo(String user, String apiKey) {
        Result result = Caller.getInstance().call("user.getInfo", apiKey, "user", user);
        return ResponseBuilder.buildItem(result, User.class);
    }

    public static User getInfo(Session session) {
        Result result = Caller.getInstance().call("user.getInfo", session, new String[0]);
        return ResponseBuilder.buildItem(result, User.class);
    }

    public static PaginatedResult<Artist> getRecommendedArtists(Session session) {
        return User.getRecommendedArtists(1, session);
    }

    public static PaginatedResult<Artist> getRecommendedArtists(int page, Session session) {
        Result result = Caller.getInstance().call("user.getRecommendedArtists", session, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Artist.class);
    }

    public static Result shout(String user, String message, Session session) {
        return Caller.getInstance().call("user.shout", session, "user", user, "message", message);
    }

    public static Collection<Album> getNewReleases(String user, String apiKey) {
        return User.getNewReleases(user, false, apiKey);
    }

    public static Collection<Album> getNewReleases(String user, boolean useRecommendations, String apiKey) {
        Result result = Caller.getInstance().call("user.getNewReleases", apiKey, "user", user, "userecs", useRecommendations ? "1" : "0");
        return ResponseBuilder.buildCollection(result, Album.class);
    }

    public static PaginatedResult<Track> getBannedTracks(String user, String apiKey) {
        return User.getBannedTracks(user, 1, apiKey);
    }

    public static PaginatedResult<Track> getBannedTracks(String user, int page, String apiKey) {
        Result result = Caller.getInstance().call("user.getBannedTracks", apiKey, "user", user, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static PaginatedResult<Shout> getShouts(String user, String apiKey) {
        return User.getShouts(user, -1, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String user, int page, String apiKey) {
        return User.getShouts(user, page, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        MapUtilities.nullSafePut(params, "limit", limit);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("user.getShouts", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Shout.class);
    }

    public static <T extends MusicEntry> PaginatedResult<T> getPersonalTags(String user, String tag, Class<T> taggingType, String apiKey) {
        return User.getPersonalTags(user, tag, taggingType, -1, -1, apiKey);
    }

    public static <T extends MusicEntry> PaginatedResult<T> getPersonalTags(String user, String tag, Class<T> taggingType, int page, String apiKey) {
        return User.getPersonalTags(user, tag, taggingType, page, -1, apiKey);
    }

    public static <T extends MusicEntry> PaginatedResult<T> getPersonalTags(String user, String tag, Class<T> taggingType, int page, int limit, String apiKey) {
        Map<String, String> params = StringUtilities.map("user", user, "tag", tag);
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        String taggingTypeParam = "taggingtype";
        if (taggingType == Track.class) {
            params.put(taggingTypeParam, "track");
        } else if (taggingType == Artist.class) {
            params.put(taggingTypeParam, "artist");
        } else if (taggingType == Album.class) {
            params.put(taggingTypeParam, "album");
        } else {
            throw new IllegalArgumentException("Parameter taggingType has to be one of Artist.class, Album.class or Track.class.");
        }
        Result result = Caller.getInstance().call("user.getPersonalTags", apiKey, params);
        if (!result.isSuccessful()) {
            return new PaginatedResult(0, 0, Collections.emptyList());
        }
        String childElementName = params.get(taggingTypeParam) + "s";
        DomElement contentElement = result.getContentElement();
        DomElement childElement = contentElement.getChild(childElementName);
        return ResponseBuilder.buildPaginatedResult(contentElement, childElement, taggingType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserFactory
    implements ItemFactory<User> {
        private UserFactory() {
        }

        @Override
        public User createItemFromElement(DomElement element) {
            User user = new User(element.getChildText("name"), element.getChildText("url"));
            user.id = element.getChildText("id");
            if (element.hasChild("realname")) {
                user.realname = element.getChildText("realname");
            }
            ImageHolder.loadImages(user, element);
            user.language = element.getChildText("lang");
            user.country = element.getChildText("country");
            if (element.hasChild("age")) {
                try {
                    user.age = Integer.parseInt(element.getChildText("age"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            user.gender = element.getChildText("gender");
            user.subscriber = "1".equals(element.getChildText("subscriber"));
            if (element.hasChild("playcount")) {
                try {
                    user.playcount = Integer.parseInt(element.getChildText("playcount"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (element.hasChild("playlists")) {
                try {
                    user.numPlaylists = Integer.parseInt(element.getChildText("playlists"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (element.hasChild("registered")) {
                String unixtime = element.getChild("registered").getAttribute("unixtime");
                user.registeredDate = new Date(Long.parseLong(unixtime) * 1000L);
            }
            return user;
        }
    }
}

