/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.BuyLink;
import de.umass.lastfm.Caller;
import de.umass.lastfm.ImageHolder;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.MusicEntry;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Shout;
import de.umass.lastfm.Tag;
import de.umass.lastfm.User;
import de.umass.lastfm.scrobble.IgnoredMessageCode;
import de.umass.lastfm.scrobble.ScrobbleData;
import de.umass.lastfm.scrobble.ScrobbleResult;
import de.umass.util.MapUtilities;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track
extends MusicEntry {
    static final ItemFactory<Track> FACTORY = new TrackFactory();
    public static final String ARTIST_PAGE = "artistpage";
    public static final String ALBUM_PAGE = "albumpage";
    public static final String TRACK_PAGE = "trackpage";
    private String artist;
    private String artistMbid;
    protected String album;
    private String albumMbid;
    private int position = -1;
    private boolean fullTrackAvailable;
    private boolean nowPlaying;
    private Date playedWhen;
    protected int duration;
    protected String location;
    protected Map<String, String> lastFmExtensionInfos = new HashMap<String, String>();

    protected Track(String name, String url, String artist) {
        super(name, url);
        this.artist = artist;
    }

    protected Track(String name, String url, String mbid, int playcount, int listeners, boolean streamable, String artist, String artistMbid, boolean fullTrackAvailable, boolean nowPlaying) {
        super(name, url, mbid, playcount, listeners, streamable);
        this.artist = artist;
        this.artistMbid = artistMbid;
        this.fullTrackAvailable = fullTrackAvailable;
        this.nowPlaying = nowPlaying;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getArtistMbid() {
        return this.artistMbid;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumMbid() {
        return this.albumMbid;
    }

    public boolean isFullTrackAvailable() {
        return this.fullTrackAvailable;
    }

    public boolean isNowPlaying() {
        return this.nowPlaying;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLastFmInfo(String key) {
        return this.lastFmExtensionInfos.get(key);
    }

    public Date getPlayedWhen() {
        return this.playedWhen;
    }

    public int getPosition() {
        return this.position;
    }

    public static Collection<Track> search(String track, String apiKey) {
        return Track.search(null, track, 30, apiKey);
    }

    public static Collection<Track> search(String artist, String track, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("track", track);
        params.put("limit", String.valueOf(limit));
        MapUtilities.nullSafePut(params, "artist", artist);
        Result result = Caller.getInstance().call("track.search", apiKey, params);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        DomElement matches = element.getChild("trackmatches");
        return ResponseBuilder.buildCollection(matches, Track.class);
    }

    public static Collection<Tag> getTopTags(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getTopTags", apiKey, params);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static Collection<User> getTopFans(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getTopFans", apiKey, params);
        return ResponseBuilder.buildCollection(result, User.class);
    }

    public static Result addTags(String artist, String track, String tags, Session session) {
        return Caller.getInstance().call("track.addTags", session, "artist", artist, "track", track, "tags", tags);
    }

    public static Result removeTag(String artist, String track, String tag, Session session) {
        return Caller.getInstance().call("track.removeTag", session, "artist", artist, "track", track, "tag", tag);
    }

    public static Result share(String artist, String track, String message, String recipient, Session session) {
        Map<String, String> params = StringUtilities.map("artist", artist, "track", track, "recipient", recipient);
        MapUtilities.nullSafePut(params, "message", message);
        return Caller.getInstance().call("track.share", session, params);
    }

    public static Result love(String artist, String track, Session session) {
        return Caller.getInstance().call("track.love", session, "artist", artist, "track", track);
    }

    public static Result unlove(String artist, String track, Session session) {
        return Caller.getInstance().call("track.unlove", session, "artist", artist, "track", track);
    }

    public static Result ban(String artist, String track, Session session) {
        return Caller.getInstance().call("track.ban", session, "artist", artist, "track", track);
    }

    public static Result unban(String artist, String track, Session session) {
        return Caller.getInstance().call("track.unban", session, "artist", artist, "track", track);
    }

    public static Collection<Track> getSimilar(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getSimilar", apiKey, params);
        return ResponseBuilder.buildCollection(result, Track.class);
    }

    public static Collection<String> getTags(String artist, String track, Session session) {
        Result result = Caller.getInstance().call("track.getTags", session, "artist", artist, "track", track);
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Track getInfo(String artist, String trackOrMbid, String apiKey) {
        return Track.getInfo(artist, trackOrMbid, null, null, apiKey);
    }

    public static Track getInfo(String artist, String trackOrMbid, Locale locale, String username, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        MapUtilities.nullSafePut(params, "username", username);
        Result result = Caller.getInstance().call("track.getInfo", apiKey, params);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement content = result.getContentElement();
        DomElement album = content.getChild("album");
        Track track = FACTORY.createItemFromElement(content);
        if (album != null) {
            String pos = album.getAttribute("position");
            if (pos != null && pos.length() != 0) {
                track.position = Integer.parseInt(pos);
            }
            track.album = album.getChildText("title");
            track.albumMbid = album.getChildText("mbid");
            ImageHolder.loadImages(track, album);
        }
        return track;
    }

    public static Collection<BuyLink> getBuylinks(String artist, String albumOrMbid, String country, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        params.put("country", country);
        Result result = Caller.getInstance().call("track.getBuylinks", apiKey, params);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        DomElement physicals = element.getChild("physicals");
        DomElement downloads = element.getChild("downloads");
        ArrayList<BuyLink> links = new ArrayList<BuyLink>();
        for (DomElement e : physicals.getChildren("affiliation")) {
            links.add(BuyLink.linkFromElement(BuyLink.StoreType.PHYSICAl, e));
        }
        for (DomElement e : downloads.getChildren("affiliation")) {
            links.add(BuyLink.linkFromElement(BuyLink.StoreType.DIGITAL, e));
        }
        return links;
    }

    public static Track getCorrection(String artist, String track, String apiKey) {
        Result result = Caller.getInstance().call("track.getCorrection", apiKey, "artist", artist, "track", track);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement correctionElement = result.getContentElement().getChild("correction");
        if (correctionElement == null) {
            return new Track(track, null, artist);
        }
        DomElement trackElem = correctionElement.getChild("track");
        return FACTORY.createItemFromElement(trackElem);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String trackOrMbid, String apiKey) {
        return Track.getShouts(artist, trackOrMbid, -1, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String trackOrMbid, int page, String apiKey) {
        return Track.getShouts(artist, trackOrMbid, page, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String trackOrMbid, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        MapUtilities.nullSafePut(params, "limit", limit);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("track.getShouts", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Shout.class);
    }

    private static List<ScrobbleResult> convertToScrobbleResults(Result result, ScrobbleResultType scrobbleResultType) {
        ArrayList<ScrobbleResult> scrobbleResults = new ArrayList<ScrobbleResult>();
        if (!result.isSuccessful()) {
            ScrobbleResult scrobbleResult = new ScrobbleResult(result);
            scrobbleResults.add(scrobbleResult);
        } else {
            DomElement element = result.getContentElement();
            if (scrobbleResultType == ScrobbleResultType.NOW_PLAYING) {
                ScrobbleResult scrobbleResult = new ScrobbleResult(result);
                Track.parseIntoScrobbleResult(element, scrobbleResult);
                scrobbleResults.add(scrobbleResult);
            } else if (scrobbleResultType == ScrobbleResultType.SINGLE_SCROBBLE) {
                ScrobbleResult scrobbleResult = new ScrobbleResult(result);
                Track.parseIntoScrobbleResult(element.getChild("scrobble"), scrobbleResult);
                scrobbleResults.add(scrobbleResult);
            } else if (scrobbleResultType == ScrobbleResultType.MULTIPLE_SCROBBLES) {
                for (DomElement scrobbleElement : element.getChildren("scrobble")) {
                    ScrobbleResult scrobbleResult = new ScrobbleResult(result);
                    Track.parseIntoScrobbleResult(scrobbleElement, scrobbleResult);
                    scrobbleResults.add(scrobbleResult);
                }
            }
        }
        return scrobbleResults;
    }

    private static void parseIntoScrobbleResult(DomElement scrobbleElement, ScrobbleResult scrobbleResult) {
        DomElement ignoredMessageElement;
        int ignoredMessageCode;
        DomElement trackElement = scrobbleElement.getChild("track");
        scrobbleResult.setTrack(trackElement.getText());
        scrobbleResult.setArtistCorrected(StringUtilities.convertToBoolean(trackElement.getAttribute("corrected")));
        DomElement artistElement = scrobbleElement.getChild("artist");
        scrobbleResult.setArtist(artistElement.getText());
        scrobbleResult.setArtistCorrected(StringUtilities.convertToBoolean(artistElement.getAttribute("corrected")));
        DomElement albumElement = scrobbleElement.getChild("album");
        scrobbleResult.setAlbum(albumElement.getText());
        scrobbleResult.setAlbumCorrected(StringUtilities.convertToBoolean(albumElement.getAttribute("corrected")));
        DomElement albumArtistElement = scrobbleElement.getChild("albumArtist");
        scrobbleResult.setAlbumArtist(albumArtistElement.getText());
        scrobbleResult.setAlbumArtistCorrected(StringUtilities.convertToBoolean(albumArtistElement.getAttribute("corrected")));
        String timeString = scrobbleElement.getChildText("timestamp");
        if (timeString != null) {
            scrobbleResult.setTimestamp(Integer.parseInt(timeString));
        }
        if ((ignoredMessageCode = Integer.parseInt((ignoredMessageElement = scrobbleElement.getChild("ignoredMessage")).getAttribute("code"))) > 0) {
            scrobbleResult.setIgnored(true);
            scrobbleResult.setIgnoredMessageCode(IgnoredMessageCode.valueOfCode(ignoredMessageCode));
            scrobbleResult.setIgnoredMessage(ignoredMessageElement.getText());
        }
    }

    public static ScrobbleResult scrobble(ScrobbleData scrobbleData, Session session) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("artist", scrobbleData.getArtist());
        params.put("track", scrobbleData.getTrack());
        params.put("timestamp", String.valueOf(scrobbleData.getTimestamp()));
        MapUtilities.nullSafePut(params, "album", scrobbleData.getAlbum());
        MapUtilities.nullSafePut(params, "albumArtist", scrobbleData.getAlbumArtist());
        MapUtilities.nullSafePut(params, "duration", scrobbleData.getDuration());
        MapUtilities.nullSafePut(params, "mbid", scrobbleData.getMusicBrainzId());
        MapUtilities.nullSafePut(params, "trackNumber", scrobbleData.getTrackNumber());
        MapUtilities.nullSafePut(params, "streamId", scrobbleData.getStreamId());
        params.put("chosenByUser", StringUtilities.convertFromBoolean(scrobbleData.isChosenByUser()));
        Result result = Caller.getInstance().call("track.scrobble", session, params);
        return Track.convertToScrobbleResults(result, ScrobbleResultType.SINGLE_SCROBBLE).get(0);
    }

    public static ScrobbleResult scrobble(String artistName, String trackName, int timestamp, Session session) {
        ScrobbleData scrobbleData = new ScrobbleData(artistName, trackName, timestamp);
        return Track.scrobble(scrobbleData, session);
    }

    public static List<ScrobbleResult> scrobble(List<ScrobbleData> scrobbleData, Session session) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < scrobbleData.size(); ++i) {
            ScrobbleData scrobble = scrobbleData.get(i);
            params.put("artist[" + i + "]", scrobble.getArtist());
            params.put("track[" + i + "]", scrobble.getTrack());
            params.put("timestamp[" + i + "]", String.valueOf(scrobble.getTimestamp()));
            MapUtilities.nullSafePut(params, "album[" + i + "]", scrobble.getAlbum());
            MapUtilities.nullSafePut(params, "albumArtist[" + i + "]", scrobble.getAlbumArtist());
            MapUtilities.nullSafePut(params, "duration[" + i + "]", scrobble.getDuration());
            MapUtilities.nullSafePut(params, "mbid[" + i + "]", scrobble.getMusicBrainzId());
            MapUtilities.nullSafePut(params, "trackNumber[" + i + "]", scrobble.getTrackNumber());
            MapUtilities.nullSafePut(params, "streamId[" + i + "]", scrobble.getStreamId());
            params.put("chosenByUser[" + i + "]", StringUtilities.convertFromBoolean(scrobble.isChosenByUser()));
        }
        Result result = Caller.getInstance().call("track.scrobble", session, params);
        return Track.convertToScrobbleResults(result, ScrobbleResultType.MULTIPLE_SCROBBLES);
    }

    public static ScrobbleResult updateNowPlaying(ScrobbleData scrobbleData, Session session) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("artist", scrobbleData.getArtist());
        params.put("track", scrobbleData.getTrack());
        MapUtilities.nullSafePut(params, "album", scrobbleData.getAlbum());
        MapUtilities.nullSafePut(params, "albumArtist", scrobbleData.getAlbumArtist());
        MapUtilities.nullSafePut(params, "duration", scrobbleData.getDuration());
        MapUtilities.nullSafePut(params, "mbid", scrobbleData.getMusicBrainzId());
        MapUtilities.nullSafePut(params, "trackNumber", scrobbleData.getTrackNumber());
        MapUtilities.nullSafePut(params, "streamId", scrobbleData.getStreamId());
        Result result = Caller.getInstance().call("track.updateNowPlaying", session, params);
        return Track.convertToScrobbleResults(result, ScrobbleResultType.NOW_PLAYING).get(0);
    }

    public static ScrobbleResult updateNowPlaying(String artistName, String trackName, Session session) {
        ScrobbleData scrobbleData = new ScrobbleData();
        scrobbleData.setArtist(artistName);
        scrobbleData.setTrack(trackName);
        return Track.updateNowPlaying(scrobbleData, session);
    }

    @Override
    public String toString() {
        return "Track[name=" + this.name + ",artist=" + this.artist + ", album=" + this.album + ", position=" + this.position + ", duration=" + this.duration + ", location=" + this.location + ", nowPlaying=" + this.nowPlaying + ", fullTrackAvailable=" + this.fullTrackAvailable + ", playedWhen=" + this.playedWhen + ", artistMbId=" + this.artistMbid + ", albumMbId" + this.albumMbid + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrackFactory
    implements ItemFactory<Track> {
        private TrackFactory() {
        }

        @Override
        public Track createItemFromElement(DomElement element) {
            DomElement stream;
            DomElement artist;
            DomElement album;
            String duration;
            Track track = new Track(null, null, null);
            MusicEntry.loadStandardInfo(track, element);
            String nowPlayingAttr = element.getAttribute("nowplaying");
            if (nowPlayingAttr != null) {
                track.nowPlaying = Boolean.valueOf(nowPlayingAttr);
            }
            if (element.hasChild("duration") && (duration = element.getChildText("duration")).length() != 0) {
                int durationLength = Integer.parseInt(duration);
                int n = track.duration = durationLength > 10000 ? durationLength / 1000 : durationLength;
            }
            if ((album = element.getChild("album")) != null) {
                track.album = album.getText();
                track.albumMbid = album.getAttribute("mbid");
            }
            if ((artist = element.getChild("artist")).getChild("name") != null) {
                track.artist = artist.getChildText("name");
                track.artistMbid = artist.getChildText("mbid");
            } else {
                track.artist = artist.getText();
                track.artistMbid = artist.getAttribute("mbid");
            }
            DomElement date = element.getChild("date");
            if (date != null) {
                String uts = date.getAttribute("uts");
                long utsTime = Long.parseLong(uts);
                track.playedWhen = new Date(utsTime * 1000L);
            }
            if ((stream = element.getChild("streamable")) != null) {
                String s = stream.getAttribute("fulltrack");
                track.fullTrackAvailable = s != null && Integer.parseInt(s) == 1;
            }
            return track;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScrobbleResultType {
        NOW_PLAYING,
        SINGLE_SCROBBLE,
        MULTIPLE_SCROBBLES;

    }
}

