/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Artist;
import de.umass.lastfm.Caller;
import de.umass.lastfm.Chart;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Track;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
implements Comparable<Tag> {
    static final ItemFactory<Tag> FACTORY = new TagFactory();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZZ", Locale.ENGLISH);
    private String name;
    private String url;
    private int count;
    private boolean streamable;
    private int reach;
    private Date wikiLastChanged;
    private String wikiSummary;
    private String wikiText;

    private Tag(String name) {
        this.name = name;
    }

    public int getCount() {
        return this.count;
    }

    public int getTaggings() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public int getReach() {
        return this.reach;
    }

    public Date getWikiLastChanged() {
        return this.wikiLastChanged;
    }

    public String getWikiSummary() {
        return this.wikiSummary;
    }

    public String getWikiText() {
        return this.wikiText;
    }

    public static long getTagCountSum(Collection<Tag> tags) {
        long total = 0L;
        for (Tag topTag : tags) {
            total += (long)topTag.count;
        }
        return total;
    }

    public static List<Tag> filter(Collection<Tag> tags, double percentage) {
        ArrayList<Tag> tops = new ArrayList<Tag>();
        long total = Tag.getTagCountSum(tags);
        double cutOff = (double)total / 100.0 * percentage;
        for (Tag tag : tags) {
            if (!((double)tag.count > cutOff)) continue;
            tops.add(tag);
        }
        return tops;
    }

    public static Collection<Tag> getSimilar(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getSimilar", apiKey, "tag", tag);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static Collection<Tag> getTopTags(String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopTags", apiKey, new String[0]);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static Collection<Album> getTopAlbums(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopAlbums", apiKey, "tag", tag);
        return ResponseBuilder.buildCollection(result, Album.class);
    }

    public static Collection<Track> getTopTracks(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopTracks", apiKey, "tag", tag);
        return ResponseBuilder.buildCollection(result, Track.class);
    }

    public static Collection<Artist> getTopArtists(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopArtists", apiKey, "tag", tag);
        return ResponseBuilder.buildCollection(result, Artist.class);
    }

    public static Collection<Tag> search(String tag, String apiKey) {
        return Tag.search(tag, 30, apiKey);
    }

    public static Collection<Tag> search(String tag, int limit, String apiKey) {
        Result result = Caller.getInstance().call("tag.search", apiKey, "tag", tag, "limit", String.valueOf(limit));
        List<DomElement> children = result.getContentElement().getChild("tagmatches").getChildren("tag");
        ArrayList<Tag> tags = new ArrayList<Tag>(children.size());
        for (DomElement s : children) {
            tags.add(FACTORY.createItemFromElement(s));
        }
        return tags;
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, String apiKey) {
        return Tag.getWeeklyArtistChart(tag, null, null, -1, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, int limit, String apiKey) {
        return Tag.getWeeklyArtistChart(tag, null, null, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, String from, String to, int limit, String apiKey) {
        return Chart.getChart("tag.getWeeklyArtistChart", "tag", tag, "artist", from, to, limit, apiKey);
    }

    public static LinkedHashMap<String, String> getWeeklyChartList(String tag, String apiKey) {
        return Chart.getWeeklyChartList("tag.getWeeklyChartList", "tag", tag, apiKey);
    }

    public static Collection<Chart> getWeeklyChartListAsCharts(String tag, String apiKey) {
        return Chart.getWeeklyChartListAsCharts("tag", tag, apiKey);
    }

    public static Tag getInfo(String tag, String apiKey) {
        return Tag.getInfo(tag, null, apiKey);
    }

    public static Tag getInfo(String tag, Locale locale, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tag", tag);
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        Result result = Caller.getInstance().call("tag.getInfo", apiKey, params);
        return ResponseBuilder.buildItem(result, Tag.class);
    }

    @Override
    public int compareTo(Tag o) {
        return Double.compare(o.getCount(), this.getCount());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagFactory
    implements ItemFactory<Tag> {
        private TagFactory() {
        }

        @Override
        public Tag createItemFromElement(DomElement element) {
            DomElement wiki;
            Tag t = new Tag(element.getChildText("name"));
            t.url = element.getChildText("url");
            if (element.hasChild("count")) {
                t.count = Integer.parseInt(element.getChildText("count"));
            } else if (element.hasChild("taggings")) {
                t.count = Integer.parseInt(element.getChildText("taggings"));
            }
            if (element.hasChild("reach")) {
                t.reach = Integer.parseInt(element.getChildText("reach"));
            }
            if (element.hasChild("streamable")) {
                t.streamable = StringUtilities.convertToBoolean(element.getChildText("streamable"));
            }
            if ((wiki = element.getChild("wiki")) != null) {
                String publishedText = wiki.getChildText("published");
                try {
                    t.wikiLastChanged = DATE_FORMAT.parse(publishedText);
                }
                catch (ParseException e) {
                    try {
                        SimpleDateFormat clFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZZ", Locale.getDefault());
                        t.wikiLastChanged = clFormat.parse(publishedText);
                    }
                    catch (ParseException e2) {
                        // empty catch block
                    }
                }
                t.wikiSummary = wiki.getChildText("summary");
                t.wikiText = wiki.getChildText("content");
            }
            return t;
        }
    }
}

