/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.ItemFactory;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Shout {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
    static final ItemFactory<Shout> FACTORY = new ShoutFactory();
    private String body;
    private String author;
    private Date date;

    public Shout(String body, String author, Date date) {
        this.body = body;
        this.author = author;
        this.date = date;
    }

    public String getBody() {
        return this.body;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShoutFactory
    implements ItemFactory<Shout> {
        private ShoutFactory() {
        }

        @Override
        public Shout createItemFromElement(DomElement element) {
            Date date = null;
            try {
                date = DATE_FORMAT.parse(element.getChildText("date"));
            }
            catch (ParseException e) {
                date = null;
            }
            return new Shout(element.getChildText("body"), element.getChildText("author"), date);
        }
    }
}

