/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.ItemFactoryBuilder;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.Result;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseBuilder {
    private ResponseBuilder() {
    }

    private static <T> ItemFactory<T> getItemFactory(Class<T> itemClass) {
        return ItemFactoryBuilder.getFactoryBuilder().getItemFactory(itemClass);
    }

    public static <T> Collection<T> buildCollection(Result result, Class<T> itemClass) {
        return ResponseBuilder.buildCollection(result, ResponseBuilder.getItemFactory(itemClass));
    }

    public static <T> Collection<T> buildCollection(Result result, ItemFactory<T> factory) {
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        return ResponseBuilder.buildCollection(result.getContentElement(), factory);
    }

    public static <T> Collection<T> buildCollection(DomElement element, Class<T> itemClass) {
        return ResponseBuilder.buildCollection(element, ResponseBuilder.getItemFactory(itemClass));
    }

    public static <T> Collection<T> buildCollection(DomElement element, ItemFactory<T> factory) {
        if (element == null) {
            return Collections.emptyList();
        }
        List<DomElement> children = element.getChildren();
        ArrayList<T> items = new ArrayList<T>(children.size());
        for (DomElement child : children) {
            items.add(factory.createItemFromElement(child));
        }
        return items;
    }

    public static <T> PaginatedResult<T> buildPaginatedResult(Result result, Class<T> itemClass) {
        return ResponseBuilder.buildPaginatedResult(result, ResponseBuilder.getItemFactory(itemClass));
    }

    public static <T> PaginatedResult<T> buildPaginatedResult(Result result, ItemFactory<T> factory) {
        if (!result.isSuccessful()) {
            return new PaginatedResult(0, 0, Collections.emptyList());
        }
        DomElement contentElement = result.getContentElement();
        return ResponseBuilder.buildPaginatedResult(contentElement, contentElement, factory);
    }

    public static <T> PaginatedResult<T> buildPaginatedResult(DomElement contentElement, DomElement childElement, Class<T> itemClass) {
        return ResponseBuilder.buildPaginatedResult(contentElement, childElement, ResponseBuilder.getItemFactory(itemClass));
    }

    public static <T> PaginatedResult<T> buildPaginatedResult(DomElement contentElement, DomElement childElement, ItemFactory<T> factory) {
        Collection<T> items = ResponseBuilder.buildCollection(childElement, factory);
        String totalPagesAttribute = contentElement.getAttribute("totalPages");
        if (totalPagesAttribute == null) {
            totalPagesAttribute = contentElement.getAttribute("totalpages");
        }
        int page = Integer.parseInt(contentElement.getAttribute("page"));
        int totalPages = Integer.parseInt(totalPagesAttribute);
        return new PaginatedResult<T>(page, totalPages, items);
    }

    public static <T> T buildItem(Result result, Class<T> itemClass) {
        return ResponseBuilder.buildItem(result, ResponseBuilder.getItemFactory(itemClass));
    }

    public static <T> T buildItem(Result result, ItemFactory<T> factory) {
        if (!result.isSuccessful()) {
            return null;
        }
        return ResponseBuilder.buildItem(result.getContentElement(), factory);
    }

    public static <T> T buildItem(DomElement element, Class<T> itemClass) {
        return ResponseBuilder.buildItem(element, ResponseBuilder.getItemFactory(itemClass));
    }

    private static <T> T buildItem(DomElement element, ItemFactory<T> factory) {
        return factory.createItemFromElement(element);
    }
}

