/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Caller;
import de.umass.lastfm.Playlist;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.util.MapUtilities;
import de.umass.xml.DomElement;
import java.util.HashMap;
import java.util.Locale;

public class Radio {
    private String type;
    private String stationName;
    private String stationUrl;
    private boolean supportsDiscovery;
    private Session session;
    private int expiry = -1;

    private Radio(Session session) {
        this.session = session;
    }

    public String getType() {
        return this.type;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getStationUrl() {
        return this.stationUrl;
    }

    public boolean supportsDiscovery() {
        return this.supportsDiscovery;
    }

    public int playlistExpiresIn() {
        return this.expiry;
    }

    public static RadioStation search(String name, String apiKey) {
        Result result = Caller.getInstance().call("radio.search", apiKey, "name", name);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement stationElement = result.getContentElement().getChild("station");
        if (stationElement == null) {
            return null;
        }
        return new RadioStation(stationElement.getChildText("url"), stationElement.getChildText("name"));
    }

    public static Radio tune(RadioStation station, Session session) {
        return Radio.tune(station, Locale.getDefault(), session);
    }

    public static Radio tune(RadioStation station, Locale locale, Session session) {
        return Radio.tune(station.getUrl(), locale, session);
    }

    public static Radio tune(String station, Locale locale, Session session) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("station", station);
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        if (!(result = Caller.getInstance().call("radio.tune", session, params)).isSuccessful()) {
            return null;
        }
        DomElement root = result.getContentElement();
        Radio radio = new Radio(session);
        radio.type = root.getChildText("type");
        radio.stationName = root.getChildText("name");
        radio.stationUrl = root.getChildText("url");
        radio.supportsDiscovery = "1".equals(root.getChildText("type"));
        return radio;
    }

    public Playlist getPlaylist() {
        return this.getPlaylist(false, false);
    }

    public Playlist getPlaylist(boolean discovery, boolean rtp) {
        return this.getPlaylist(discovery, rtp, false, -1.0, -1);
    }

    public Playlist getPlaylist(boolean discovery, boolean rtp, boolean buyLinks, double speedMultiplier, int bitrate) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("discovery", String.valueOf(discovery));
        params.put("rtp", String.valueOf(rtp));
        params.put("buylinks", String.valueOf(buyLinks));
        MapUtilities.nullSafePut(params, "speed_multiplier", speedMultiplier);
        MapUtilities.nullSafePut(params, "bitrate", bitrate);
        Result result = Caller.getInstance().call("radio.getPlaylist", this.session, params);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement root = result.getContentElement();
        for (DomElement e : root.getChildren("link")) {
            if (!"http://www.last.fm/expiry".equals(e.getAttribute("rel"))) continue;
            this.expiry = Integer.parseInt(e.getText());
            break;
        }
        return ResponseBuilder.buildItem(root, Playlist.class);
    }

    public static class RadioStation {
        private String name;
        private String url;

        public RadioStation(String url) {
            this(url, null);
        }

        public RadioStation(String url, String name) {
            this.url = url;
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public static RadioStation similarArtists(String artist) {
            return new RadioStation("lastfm://artist/" + artist + "/similarartists");
        }

        public static RadioStation artistFans(String artist) {
            return new RadioStation("lastfm://artist/" + artist + "/fans");
        }

        public static RadioStation library(String user) {
            return new RadioStation("lastfm://user/" + user + "/library");
        }

        public static RadioStation neighbours(String user) {
            return new RadioStation("lastfm://user/" + user + "/neighbours");
        }

        public static RadioStation lovedTracks(String user) {
            return new RadioStation("lastfm://user/" + user + "/loved");
        }

        public static RadioStation recommended(String user) {
            return new RadioStation("lastfm://user/" + user + "/recommended");
        }

        public static RadioStation tagged(String tag) {
            return new RadioStation("lastfm://globaltags/" + tag);
        }

        public static RadioStation playlist(String playlistId) {
            return new RadioStation("lastfm://playlist/" + playlistId);
        }

        public static RadioStation personalTag(String user, String tag) {
            return new RadioStation("lastfm://usertags/" + user + "/" + tag);
        }
    }
}

