/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Artist;
import de.umass.lastfm.Event;
import de.umass.lastfm.Image;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.Playlist;
import de.umass.lastfm.Shout;
import de.umass.lastfm.Tag;
import de.umass.lastfm.Track;
import de.umass.lastfm.User;
import de.umass.lastfm.Venue;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ItemFactoryBuilder {
    private static final ItemFactoryBuilder INSTANCE = new ItemFactoryBuilder();
    private Map<Class, ItemFactory> factories = new HashMap<Class, ItemFactory>();

    private ItemFactoryBuilder() {
        this.addItemFactory(Album.class, Album.FACTORY);
        this.addItemFactory(Track.class, Track.FACTORY);
        this.addItemFactory(Artist.class, Artist.FACTORY);
        this.addItemFactory(Tag.class, Tag.FACTORY);
        this.addItemFactory(Image.class, Image.FACTORY);
        this.addItemFactory(User.class, User.FACTORY);
        this.addItemFactory(Event.class, Event.FACTORY);
        this.addItemFactory(Venue.class, Venue.FACTORY);
        this.addItemFactory(Shout.class, Shout.FACTORY);
        this.addItemFactory(Playlist.class, Playlist.FACTORY);
    }

    public static ItemFactoryBuilder getFactoryBuilder() {
        return INSTANCE;
    }

    public <T> void addItemFactory(Class<T> itemClass, ItemFactory<T> factory) {
        this.factories.put(itemClass, factory);
    }

    public <T> ItemFactory<T> getItemFactory(Class<T> itemClass) {
        return this.factories.get(itemClass);
    }
}

