/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.ImageHolder;
import de.umass.lastfm.ImageSize;
import de.umass.lastfm.ItemFactory;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Image
extends ImageHolder {
    static final ItemFactory<Image> FACTORY = new ImageFactory();
    private static final DateFormat DATE_ADDED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
    private String title;
    private String url;
    private Date dateAdded;
    private String format;
    private String owner;
    private int thumbsUp;
    private int thumbsDown;

    private Image() {
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public String getFormat() {
        return this.format;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getThumbsUp() {
        return this.thumbsUp;
    }

    public int getThumbsDown() {
        return this.thumbsDown;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImageFactory
    implements ItemFactory<Image> {
        private ImageFactory() {
        }

        @Override
        public Image createItemFromElement(DomElement element) {
            DomElement votes;
            Image i = new Image();
            i.title = element.getChildText("title");
            i.url = element.getChildText("url");
            i.format = element.getChildText("format");
            try {
                i.dateAdded = DATE_ADDED_FORMAT.parse(element.getChildText("dateadded"));
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            DomElement owner = element.getChild("owner");
            if (owner != null) {
                i.owner = owner.getChildText("name");
            }
            if ((votes = element.getChild("votes")) != null) {
                i.thumbsUp = Integer.parseInt(votes.getChildText("thumbsup"));
                i.thumbsDown = Integer.parseInt(votes.getChildText("thumbsdown"));
            }
            DomElement sizes = element.getChild("sizes");
            for (DomElement image : sizes.getChildren("size")) {
                String attribute = image.getAttribute("name");
                ImageSize size = null;
                if (attribute == null) {
                    size = ImageSize.MEDIUM;
                } else {
                    try {
                        size = ImageSize.valueOf(attribute.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (size == null) continue;
                i.imageUrls.put(size, image.getText());
            }
            return i;
        }
    }
}

