/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Caller;
import de.umass.lastfm.ImageHolder;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Shout;
import de.umass.lastfm.User;
import de.umass.lastfm.Venue;
import de.umass.util.MapUtilities;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends ImageHolder {
    static final ItemFactory<Event> FACTORY = new EventFactory();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
    private int id;
    private String title;
    private Collection<String> artists;
    private String headliner;
    private Collection<TicketSupplier> tickets;
    private Date startDate;
    private Date endDate;
    private String description;
    private String url;
    private String website;
    private int attendance;
    private int reviews;
    private Venue venue;
    private AttendanceStatus userAttendanceStatus;

    private Event() {
    }

    public Collection<String> getArtists() {
        return this.artists;
    }

    public int getAttendance() {
        return this.attendance;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeadliner() {
        return this.headliner;
    }

    public int getId() {
        return this.id;
    }

    public int getReviews() {
        return this.reviews;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getWebsite() {
        return this.website;
    }

    public Collection<TicketSupplier> getTicketSuppliers() {
        return this.tickets;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public AttendanceStatus getAttendanceStatus() {
        return this.userAttendanceStatus;
    }

    public static Event getInfo(String eventId, String apiKey) {
        Result result = Caller.getInstance().call("event.getInfo", apiKey, "event", eventId);
        return ResponseBuilder.buildItem(result, Event.class);
    }

    public static Result attend(String eventId, AttendanceStatus status, Session session) {
        return Caller.getInstance().call("event.attend", session, "event", eventId, "status", String.valueOf(status.getId()));
    }

    public static Result share(String eventId, String recipients, String message, Session session) {
        return Caller.getInstance().call("event.share", session, "event", eventId, "recipient", recipients, "message", message);
    }

    public static Collection<User> getAttendees(String eventId, String apiKey) {
        Result result = Caller.getInstance().call("event.getAttendees", apiKey, "event", eventId);
        return ResponseBuilder.buildCollection(result, User.class);
    }

    public static PaginatedResult<Shout> getShouts(String eventId, String apiKey) {
        return Event.getShouts(eventId, -1, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String eventId, int page, String apiKey) {
        return Event.getShouts(eventId, page, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String eventId, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("event", eventId);
        MapUtilities.nullSafePut(params, "limit", limit);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("event.getShouts", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Shout.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventFactory
    implements ItemFactory<Event> {
        private EventFactory() {
        }

        @Override
        public Event createItemFromElement(DomElement element) {
            Event event = new Event();
            ImageHolder.loadImages(event, element);
            event.id = Integer.parseInt(element.getChildText("id"));
            event.title = element.getChildText("title");
            event.description = element.getChildText("description");
            event.url = element.getChildText("url");
            if (element.hasChild("attendance")) {
                event.attendance = Integer.parseInt(element.getChildText("attendance"));
            }
            if (element.hasChild("reviews")) {
                event.reviews = Integer.parseInt(element.getChildText("reviews"));
            }
            try {
                event.startDate = DATE_FORMAT.parse(element.getChildText("startDate"));
                if (element.hasChild("endDate")) {
                    event.endDate = DATE_FORMAT.parse(element.getChildText("endDate"));
                }
            }
            catch (ParseException e1) {
                // empty catch block
            }
            event.headliner = element.getChild("artists").getChildText("headliner");
            event.artists = new ArrayList();
            for (DomElement artist : element.getChild("artists").getChildren("artist")) {
                event.artists.add(artist.getText());
            }
            event.website = element.getChildText("website");
            event.tickets = new ArrayList();
            if (element.hasChild("tickets")) {
                for (DomElement ticket : element.getChild("tickets").getChildren("ticket")) {
                    event.tickets.add(new TicketSupplier(ticket.getAttribute("supplier"), ticket.getText()));
                }
            }
            if (element.hasAttribute("status")) {
                event.userAttendanceStatus = AttendanceStatus.getByID(Integer.parseInt(element.getAttribute("status")));
            }
            if (element.hasChild("venue")) {
                event.venue = ResponseBuilder.buildItem(element.getChild("venue"), Venue.class);
            }
            return event;
        }
    }

    public static class TicketSupplier {
        private String name;
        private String website;

        public TicketSupplier(String name, String website) {
            this.name = name;
            this.website = website;
        }

        public String getName() {
            return this.name;
        }

        public String getWebsite() {
            return this.website;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttendanceStatus {
        ATTENDING(0),
        MAYBE_ATTENDING(1),
        NOT_ATTENDING(2);

        private int id;

        private AttendanceStatus(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static AttendanceStatus getByID(int statusId) {
            for (AttendanceStatus status : AttendanceStatus.values()) {
                if (status.id != statusId) continue;
                return status;
            }
            return null;
        }
    }
}

