/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Artist;
import de.umass.lastfm.Caller;
import de.umass.lastfm.MusicEntry;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Tag;
import de.umass.lastfm.Track;
import de.umass.util.MapUtilities;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart<T extends MusicEntry> {
    private Date from;
    private Date to;
    private Collection<T> entries;

    public Chart(Date from, Date to, Collection<T> entries) {
        this.from = from;
        this.to = to;
        this.entries = entries;
    }

    public Collection<T> getEntries() {
        return this.entries;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    static <T extends MusicEntry> Chart<T> getChart(String method, String sourceType, String source, String target, String from, String to, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(sourceType, source);
        return Chart.getChart(method, target, params, from, to, limit, apiKey);
    }

    static <T extends MusicEntry> Chart<T> getChart(String method, String target, Map<String, String> params, String from, String to, int limit, String apiKey) {
        if (from != null && to != null) {
            params.put("from", from);
            params.put("to", to);
        }
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call(method, apiKey, params);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement element = result.getContentElement();
        List<DomElement> children = element.getChildren(target);
        ArrayList<MusicEntry> collection = new ArrayList<MusicEntry>(children.size());
        boolean targetArtist = "artist".equals(target);
        boolean targetTrack = "track".equals(target);
        boolean targetAlbum = "album".equals(target);
        for (DomElement domElement : children) {
            if (targetArtist) {
                collection.add(ResponseBuilder.buildItem(domElement, Artist.class));
            }
            if (targetTrack) {
                collection.add(ResponseBuilder.buildItem(domElement, Track.class));
            }
            if (!targetAlbum) continue;
            collection.add(ResponseBuilder.buildItem(domElement, Album.class));
        }
        long fromTime = 0L;
        long toTime = 0L;
        if (element.hasAttribute("from")) {
            fromTime = 1000L * Long.parseLong(element.getAttribute("from"));
            toTime = 1000L * Long.parseLong(element.getAttribute("to"));
        }
        return new Chart(new Date(fromTime), new Date(toTime), collection);
    }

    static LinkedHashMap<String, String> getWeeklyChartList(String methodName, String paramName, String paramValue, String apiKey) {
        Result result = Caller.getInstance().call(methodName, apiKey, paramName, paramValue);
        if (!result.isSuccessful()) {
            return new LinkedHashMap<String, String>(0);
        }
        DomElement element = result.getContentElement();
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        for (DomElement domElement : element.getChildren("chart")) {
            list.put(domElement.getAttribute("from"), domElement.getAttribute("to"));
        }
        return list;
    }

    static Collection<Chart> getWeeklyChartListAsCharts(String sourceType, String source, String apiKey) {
        Result result = Caller.getInstance().call(sourceType + ".getWeeklyChartList", apiKey, sourceType, source);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Chart> list = new ArrayList<Chart>();
        for (DomElement domElement : element.getChildren("chart")) {
            long fromTime = 1000L * Long.parseLong(domElement.getAttribute("from"));
            long toTime = 1000L * Long.parseLong(domElement.getAttribute("to"));
            list.add(new Chart(new Date(fromTime), new Date(toTime), null));
        }
        return list;
    }

    public static PaginatedResult<Artist> getTopArtists(String apiKey) {
        return Chart.getTopArtists(1, apiKey);
    }

    public static PaginatedResult<Artist> getTopArtists(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getTopArtists", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Artist.class);
    }

    public static PaginatedResult<Tag> getTopTags(String apiKey) {
        return Chart.getTopTags(1, apiKey);
    }

    public static PaginatedResult<Tag> getTopTags(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getTopTags", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Tag.class);
    }

    public static PaginatedResult<Track> getTopTracks(String apiKey) {
        return Chart.getTopTracks(1, apiKey);
    }

    public static PaginatedResult<Track> getTopTracks(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getTopTracks", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static PaginatedResult<Track> getLovedTracks(String apiKey) {
        return Chart.getLovedTracks(1, apiKey);
    }

    public static PaginatedResult<Track> getLovedTracks(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getLovedTracks", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static PaginatedResult<Track> getHypedTracks(String apiKey) {
        return Chart.getHypedTracks(1, apiKey);
    }

    public static PaginatedResult<Track> getHypedTracks(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getHypedTracks", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static PaginatedResult<Artist> getHypedArtists(String apiKey) {
        return Chart.getHypedArtists(1, apiKey);
    }

    public static PaginatedResult<Artist> getHypedArtists(int page, String apiKey) {
        Result result = Caller.getInstance().call("chart.getHypedArtists", apiKey, "page", String.valueOf(page));
        return ResponseBuilder.buildPaginatedResult(result, Artist.class);
    }
}

