/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.xml.DomElement;

public class BuyLink {
    private StoreType type;
    private String name;
    private String link;
    private String icon;
    private boolean search;
    private String currency;
    private double price;

    private BuyLink(String name, StoreType type, String link) {
        this.name = name;
        this.type = type;
        this.link = link;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public StoreType getType() {
        return this.type;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isSearch() {
        return this.search;
    }

    public String getCurrency() {
        return this.currency;
    }

    public double getPrice() {
        return this.price;
    }

    static BuyLink linkFromElement(StoreType type, DomElement element) {
        BuyLink link = new BuyLink(element.getChildText("supplierName"), type, element.getChildText("buyLink"));
        link.search = "1".equals(element.getChildText("isSearch"));
        link.icon = element.getChildText("supplierIcon");
        if (link.icon != null && link.icon.length() == 0) {
            link.icon = null;
        }
        if (element.hasChild("price")) {
            DomElement child = element.getChild("price");
            link.currency = child.getChildText("currency");
            link.price = Double.parseDouble(child.getChildText("amount"));
        }
        return link;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreType {
        PHYSICAl,
        DIGITAL;

    }
}

