/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.BuyLink;
import de.umass.lastfm.Caller;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.MusicEntry;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Shout;
import de.umass.lastfm.Tag;
import de.umass.lastfm.Track;
import de.umass.util.MapUtilities;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Album
extends MusicEntry {
    static final ItemFactory<Album> FACTORY = new AlbumFactory();
    private static final DateFormat RELEASE_DATE_FORMAT = new SimpleDateFormat("d MMM yyyy, HH:mm", Locale.ENGLISH);
    private static final DateFormat RELEASE_DATE_FORMAT_2 = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private String artist;
    private Date releaseDate;
    private Collection<Track> tracks;

    private Album(String name, String url, String artist) {
        super(name, url);
        this.artist = artist;
    }

    private Album(String name, String url, String mbid, int playcount, int listeners, boolean streamable, String artist) {
        super(name, url, mbid, playcount, listeners, streamable);
        this.artist = artist;
    }

    public String getArtist() {
        return this.artist;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public Collection<Track> getTracks() {
        return this.tracks;
    }

    public static Album getInfo(String artist, String albumOrMbid, String apiKey) {
        return Album.getInfo(artist, albumOrMbid, null, apiKey);
    }

    public static Album getInfo(String artist, String albumOrMbid, String username, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        MapUtilities.nullSafePut(params, "username", username);
        Result result = Caller.getInstance().call("album.getInfo", apiKey, params);
        return ResponseBuilder.buildItem(result, Album.class);
    }

    public static Result addTags(String artist, String album, String tags, Session session) {
        return Caller.getInstance().call("album.addTags", session, "artist", artist, "album", album, "tags", tags);
    }

    public static Result removeTag(String artist, String album, String tag, Session session) {
        return Caller.getInstance().call("album.removeTag", session, "artist", artist, "album", album, "tag", tag);
    }

    public static Collection<String> getTags(String artist, String album, Session session) {
        Result result = Caller.getInstance().call("album.getTags", session, "artist", artist, "album", album);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Collection<Album> search(String album, String apiKey) {
        Result result = Caller.getInstance().call("album.search", apiKey, "album", album);
        DomElement matches = result.getContentElement().getChild("albummatches");
        List<DomElement> children = matches.getChildren("album");
        ArrayList<Album> albums = new ArrayList<Album>(children.size());
        for (DomElement element : children) {
            albums.add(FACTORY.createItemFromElement(element));
        }
        return albums;
    }

    public static Collection<BuyLink> getBuylinks(String artist, String albumOrMbid, String country, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        params.put("country", country);
        Result result = Caller.getInstance().call("album.getBuylinks", apiKey, params);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        DomElement physicals = element.getChild("physicals");
        DomElement downloads = element.getChild("downloads");
        ArrayList<BuyLink> links = new ArrayList<BuyLink>();
        for (DomElement e : physicals.getChildren("affiliation")) {
            links.add(BuyLink.linkFromElement(BuyLink.StoreType.PHYSICAl, e));
        }
        for (DomElement e : downloads.getChildren("affiliation")) {
            links.add(BuyLink.linkFromElement(BuyLink.StoreType.DIGITAL, e));
        }
        return links;
    }

    public static Collection<Tag> getTopTags(String artist, String albumOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        Result result = Caller.getInstance().call("album.getTopTags", apiKey, params);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String albumOrMbid, String apiKey) {
        return Album.getShouts(artist, albumOrMbid, -1, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String albumOrMbid, int page, String apiKey) {
        return Album.getShouts(artist, albumOrMbid, page, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artist, String albumOrMbid, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        MapUtilities.nullSafePut(params, "limit", limit);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("album.getShouts", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Shout.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlbumFactory
    implements ItemFactory<Album> {
        private AlbumFactory() {
        }

        @Override
        public Album createItemFromElement(DomElement element) {
            String releaseDateAttribute;
            Album album = new Album(null, null, null);
            MusicEntry.loadStandardInfo(album, element);
            if (element.hasChild("artist")) {
                album.artist = element.getChild("artist").getChildText("name");
                if (album.artist == null) {
                    album.artist = element.getChildText("artist");
                }
            }
            if (element.hasChild("tracks")) {
                album.tracks = ResponseBuilder.buildCollection(element.getChild("tracks"), Track.class);
            }
            if (element.hasChild("releasedate")) {
                try {
                    album.releaseDate = RELEASE_DATE_FORMAT.parse(element.getChildText("releasedate"));
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if ((releaseDateAttribute = element.getAttribute("releasedate")) != null) {
                try {
                    album.releaseDate = RELEASE_DATE_FORMAT_2.parse(releaseDateAttribute);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            return album;
        }
    }
}

