/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.domain;

import de.twenty11.unitprofile.domain.TransformationResult;

public class Transformation {
    private String className;
    private TransformationResult transformationResult;
    private int origSize;
    private int newLength;

    public Transformation(String className, int origSize) {
        this.className = className.replace("/", ".");
        this.origSize = origSize;
        this.transformationResult = TransformationResult.UNTOUCHED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transformation other = (Transformation)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.className);
        sb.append(" [").append((Object)this.transformationResult).append("]");
        sb.append(" (").append(this.origSize).append(" ");
        if (TransformationResult.TRANSFORMED.equals((Object)this.transformationResult)) {
            sb.append("-> ").append(this.newLength);
        }
        sb.append(" bytes)");
        return sb.toString();
    }

    public void update(int newLength) {
        this.newLength = newLength;
        if (newLength != this.origSize) {
            this.transformationResult = TransformationResult.TRANSFORMED;
        }
    }

    public String getClassName() {
        return this.className;
    }
}

