/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.domain;

import de.twenty11.unitprofile.domain.MethodInvocation;
import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javassist.expr.NewExpr;

public class MethodDescriptor
implements Comparable<MethodDescriptor> {
    private final int lineNumber;
    private String className;
    private String methodName;
    private List<MethodInvocation> invocations = new ArrayList<MethodInvocation>();

    public MethodDescriptor(String className, String methodName, int lineNumber) {
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public MethodDescriptor(NewExpr newExpr) throws NotFoundException {
        this(newExpr.getClassName(), newExpr.getConstructor().getName(), newExpr.getLineNumber());
    }

    public void addInvocation(MethodInvocation invocation) {
        this.invocations.add(invocation);
    }

    public String getBeforeBody() {
        return "{ProfilerCallback.before(\"" + this.className + "\", \"" + this.methodName + "\", " + this.lineNumber + ");}";
    }

    public String getAfter() {
        return "{ProfilerCallback.after(\"" + this.className + "\", \"" + this.methodName + "\");}";
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className).append("#").append(this.methodName);
        return sb.toString();
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }
}

