/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.agent;

import de.twenty11.unitprofile.agent.ProfilingExprEditor;
import de.twenty11.unitprofile.callback.ProfilerCallback;
import de.twenty11.unitprofile.domain.MethodDescriptor;
import de.twenty11.unitprofile.domain.Transformation;
import de.twenty11.unitprofiler.annotations.Profile;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.expr.ExprEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingClassFileTransformer
implements ClassFileTransformer {
    private static final String PROFILE_ANNOTATION = "@" + Profile.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(ProfilingClassFileTransformer.class);
    private List<Transformation> transformations = new ArrayList<Transformation>();
    private List<MethodDescriptor> instrumentations = new ArrayList<MethodDescriptor>();
    private CtClass profilerCallbackCtClass;
    private Instrumentation instrumentation;

    public ProfilingClassFileTransformer(Instrumentation inst) {
        this.instrumentation = inst;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!className.startsWith("de/")) {
            return classfileBuffer;
        }
        Transformation transformation = this.trackTransformations(className, loader, classBeingRedefined, protectionDomain, classfileBuffer);
        byte[] byteCode = classfileBuffer;
        ClassPool classPool = ClassPool.getDefault();
        classPool.importPackage("de.twenty11.unitprofile.callback");
        try {
            List<CtMethod> annotatedMethodsToProfile;
            CtClass ctClass = classPool.get(className.replace("/", "."));
            if (this.profilerCallbackCtClass == null) {
                this.profilerCallbackCtClass = classPool.get(ProfilerCallback.class.getName());
            }
            if ((annotatedMethodsToProfile = this.findMethodsToProfile(ctClass)).size() > 0) {
                this.logInfoAboutAnnotatedMethodsFound(annotatedMethodsToProfile);
            }
            for (CtMethod m : annotatedMethodsToProfile) {
                this.startProfiling(ctClass, this.profilerCallbackCtClass, m);
            }
            byteCode = ctClass.toBytecode();
            transformation.update(byteCode.length);
            logger.debug("transformation updated '{}'", (Object)transformation);
            ctClass.detach();
        }
        catch (NotFoundException nfe) {
            logger.warn("{}", (Object)nfe.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return byteCode;
    }

    private Transformation trackTransformations(String className, ClassLoader loader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        Transformation transformation = new Transformation(className, classfileBuffer.length);
        if (this.transformations.contains(transformation)) {
            logger.warn("re-transforming '{}'", (Object)transformation);
        } else {
            this.transformations.add(transformation);
        }
        return transformation;
    }

    private void logInfoAboutAnnotatedMethodsFound(List<CtMethod> annotatedMethodsToProfile) {
        logger.info("found " + annotatedMethodsToProfile.size() + " method(s) annotated for profiling: ");
        for (CtMethod ctMethod : annotatedMethodsToProfile) {
            logger.info(" * {}", (Object)(ctMethod.getDeclaringClass().getName() + "#" + ctMethod.getName()));
        }
        logger.info("");
    }

    private final void startProfiling(CtClass classWithProfilingAnnotatedMethod, CtClass profilerClass, CtMethod m) throws Exception {
        if (!this.instrument(m)) {
            return;
        }
        int lineNumber = m.getMethodInfo().getLineNumber(0);
        String code = "{ProfilerCallback.start(\"" + m.getDeclaringClass().getName() + "\", \"" + m.getName() + "\", " + lineNumber + ");}";
        logger.warn("code: '{}'", (Object)code);
        m.insertBefore(code);
        m.insertAfter("{ProfilerCallback.stop(\"" + m.getDeclaringClass().getName() + "\", \"" + m.getName() + "\");}");
        m.instrument((ExprEditor)new ProfilingExprEditor(this, classWithProfilingAnnotatedMethod));
        classWithProfilingAnnotatedMethod.instrument((ExprEditor)new ProfilingExprEditor(this, classWithProfilingAnnotatedMethod));
    }

    protected final void profile(CtMethod m, CtClass cc) throws CannotCompileException {
        if (!this.instrument(m)) {
            return;
        }
        int lineNumber = m.getMethodInfo().getLineNumber(0);
        logger.debug("profiling {}#{} ({})", new Object[]{cc.getName(), m.getName(), lineNumber});
        if (!Modifier.isStatic((int)m.getModifiers())) {
            m.insertBefore("{ProfilerCallback.before(this.getClass().getName(), \"" + m.getName() + "\", " + lineNumber + ");}");
            m.insertAfter("{ProfilerCallback.after(this.getClass().getName(), \"" + m.getName() + "\");}");
            m.instrument((ExprEditor)new ProfilingExprEditor(this, cc));
        } else {
            m.insertBefore("{ProfilerCallback.before(\"" + m.getDeclaringClass().getName() + "\", \"" + m.getName() + "\", " + lineNumber + ");}");
            m.insertAfter("{ProfilerCallback.after(\"" + m.getDeclaringClass().getName() + "\", \"" + m.getName() + "\");}");
            m.instrument((ExprEditor)new ProfilingExprEditor(this, cc));
        }
    }

    private List<CtMethod> findMethodsToProfile(CtClass cc) {
        ArrayList<CtMethod> methodsToProfile = new ArrayList<CtMethod>();
        CtMethod[] declaredMethods = cc.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            try {
                Object[] annotations = declaredMethods[i].getAnnotations();
                if (annotations == null) continue;
                for (int j = 0; j < annotations.length; ++j) {
                    if (!annotations[j].toString().equals(PROFILE_ANNOTATION)) continue;
                    methodsToProfile.add(declaredMethods[i]);
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return methodsToProfile;
    }

    public boolean isAlreadyInstrumented(MethodDescriptor instrumentation) {
        return this.instrumentations.contains(instrumentation);
    }

    public void addInstrumentation(MethodDescriptor instrumentation) {
        this.instrumentations.add(instrumentation);
    }

    public List<MethodDescriptor> getInstrumentations() {
        return this.instrumentations;
    }

    private boolean instrument(CtMethod method) {
        if (method.getDeclaringClass().isFrozen()) {
            logger.warn("'{}' is 'frozen'", (Object)method.getDeclaringClass().getName());
            return false;
        }
        String objectName = method.getDeclaringClass().getName();
        MethodDescriptor instrumentation = new MethodDescriptor(objectName, method.getName(), method.getMethodInfo().getLineNumber(0));
        if (this.instrumentations.contains(instrumentation)) {
            return false;
        }
        logger.debug("added to instrumentations: " + objectName + "#" + method.getName() + "(line " + method.getMethodInfo().getLineNumber(0) + ")");
        this.instrumentations.add(instrumentation);
        CodeAttribute ca = method.getMethodInfo().getCodeAttribute();
        return ca != null;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public Transformation getTransformation(String classname) {
        for (Transformation transformation : this.transformations) {
            if (!transformation.getClassName().equals(classname)) continue;
            return transformation;
        }
        return null;
    }
}

