/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.domain;

import de.twenty11.unitprofile.domain.Clock;
import de.twenty11.unitprofile.domain.MethodDescriptor;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class MethodInvocation {
    private int lineNumber;
    private List<Clock> durations = new ArrayList<Clock>();
    private static ArrayDeque<Clock> clocks = new ArrayDeque();
    private String cls;
    private String method;
    private List<MethodInvocation> children = new ArrayList<MethodInvocation>();
    private double timeShare;
    DecimalFormat df = new DecimalFormat("#.00");
    DecimalFormat longFormat = new DecimalFormat("###,##0");
    private MethodInvocation parent;
    private double selfTimeShare;

    public MethodInvocation(MethodDescriptor methodDescriptor) {
        this(null, methodDescriptor);
    }

    public MethodInvocation(MethodInvocation parent, MethodDescriptor methodDescriptor) {
        this.newTimer();
        this.cls = methodDescriptor.getClassName();
        this.method = methodDescriptor.getMethodName();
        this.parent = parent;
        this.lineNumber = methodDescriptor.getLineNumber();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void increment() {
        this.newTimer();
    }

    private void addChild(MethodInvocation invocation) {
        this.children.add(invocation);
    }

    public void setEnd(long currentTimeMillis) {
        Clock newestTimer = clocks.pollLast();
        newestTimer.stop();
    }

    public MethodInvocation getParent() {
        return this.parent;
    }

    public String getCls() {
        return this.cls;
    }

    public String getMethod() {
        return this.method;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<MethodInvocation> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cls).append("#").append(this.method).append(" ").append(this.getTime());
        sb.append(", ").append(this.children.size()).append(" children");
        return sb.toString();
    }

    public long getTime() {
        long time = 0L;
        for (Clock timer : this.durations) {
            time += timer.getElapsed();
        }
        return time;
    }

    public long getSelfTime() {
        long childrenTime = 0L;
        for (MethodInvocation child : this.children) {
            childrenTime += child.getTime();
        }
        return this.getTime() - childrenTime;
    }

    private int getCount() {
        return this.durations.size();
    }

    public String dump() {
        return this.dump(0);
    }

    private String dump(int indentation) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cls).append("#").append(this.method).append(" (").append("").append("): ").append(this.getTime());
        sb.append(" ").append(this.timeShare).append("%");
        sb.append("\n");
        if (this.children.size() != 0) {
            for (MethodInvocation invocation : this.children) {
                sb.append(invocation.dump(++indentation));
            }
        }
        return sb.toString();
    }

    public void calc() {
        this.calc(null);
    }

    private void calc(Long parentTime) {
        if (parentTime == null) {
            this.setTimeShare(100.0);
            parentTime = this.getTime();
        } else {
            this.setTimeShare(100.0 * (double)this.getTime() / (double)parentTime.longValue());
        }
        this.setSelfTimeShare(100.0 * (double)this.getSelfTime() / (double)this.getTime());
        for (MethodInvocation invocation : this.children) {
            invocation.calc(parentTime);
        }
    }

    private void setTimeShare(double d) {
        this.timeShare = d;
    }

    private void setSelfTimeShare(double d) {
        this.selfTimeShare = d;
    }

    public String treetable() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table id=\"treetable1\">");
        sb.append("<caption>\n");
        sb.append("<a href='#' onclick=\"jQuery('#treetable1').treetable('expandAll'); return false;\">Expand all</a>\n");
        sb.append("<a href='#' onclick=\"jQuery('#treetable1').treetable('collapseAll'); return false;\">Collapse all</a>\n");
        sb.append("</caption>\n");
        sb.append("<thead>\n");
        sb.append(" <tr>\n");
        sb.append("   <th>Method</th>\n");
        sb.append("   <th align='right'>Time (ms)</th>\n");
        sb.append("   <th align='right'>Time (%)</th>\n");
        sb.append("   <th>&nbsp;</th>\n");
        sb.append("   <th align='right'>Self Time (ms)</th>\n");
        sb.append("   <th align='right'>Self Time (%)</th>\n");
        sb.append("   <th align='right'>Count</th>\n");
        sb.append("   <th align='right'>Time/Invocation</th>\n");
        sb.append(" </tr>\n");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        sb.append(this.rowInTreeTable(this, 0, null));
        sb.append("</tbody>\n");
        sb.append("</table>");
        return sb.toString();
    }

    public String rowInTreeTable(MethodInvocation inv, int indentation, Integer parentId) {
        StringBuilder sb = new StringBuilder();
        Integer id = indentation;
        sb.append("\n<tr data-tt-id='").append(id).append("'");
        if (parentId != null) {
            sb.append(" data-tt-parent-id='").append(parentId).append("'");
        }
        sb.append(">");
        sb.append("<td align='left'>").append(inv.cls).append("#").append(inv.method).append(" (").append(inv.getLineNumber()).append(")").append("</td>");
        sb.append("<td align='right'>").append(this.longFormat.format(inv.getTime())).append("</td>");
        sb.append("<td align='right'>").append(this.df.format(inv.timeShare)).append("% </td>");
        sb.append("<td align='left'>");
        sb.append("<span class='graph'><span style='width: ").append(Math.round(inv.timeShare)).append("px;' class='bar'></span></span>");
        sb.append("</td>");
        sb.append("</td>");
        sb.append("<td align='right'>").append(inv.getSelfTime()).append("</td>");
        sb.append("<td align='right'>").append(this.df.format(inv.selfTimeShare)).append("%</td>");
        sb.append("<td align='right'>").append(inv.getCount()).append("</td>");
        sb.append("<td align='right'>").append(inv.getTime() / (long)inv.getCount()).append("</td>");
        sb.append("</tr>");
        if (inv.children.size() != 0) {
            for (MethodInvocation child : inv.children) {
                sb.append(this.rowInTreeTable(child, ++indentation, id));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void newTimer() {
        Clock timer = new Clock();
        this.durations.add(timer);
        clocks.add(timer);
    }
}

