/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.callback;

import de.twenty11.unitprofile.agent.Agent;
import de.twenty11.unitprofile.domain.MethodDescriptor;
import de.twenty11.unitprofile.domain.MethodInvocation;
import de.twenty11.unitprofile.output.OutputGenerator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerCallback {
    private static final Logger logger = LoggerFactory.getLogger(ProfilerCallback.class);
    private static List<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
    private static ArrayDeque<MethodInvocation> callstack = new ArrayDeque();

    public static MethodInvocation start(String objectName, String methodName, int lineNumber) {
        ProfilerCallback.bigMessage("Starting profiling... " + objectName + "#" + methodName + " (" + lineNumber + ")");
        if (ProfilerCallback.profiling()) {
            logger.error("Profiling was already started for '{}'", (Object)(callstack.getFirst().getCls() + "#" + callstack.getFirst().getMethod()));
            throw new IllegalStateException();
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(objectName, methodName, lineNumber);
        MethodInvocation rootInvocation = new MethodInvocation(methodDescriptor);
        invocations.add(rootInvocation);
        callstack.add(rootInvocation);
        Agent.setRootInvocation(rootInvocation);
        return rootInvocation;
    }

    public static void stop(String objectName, String methodName) {
        ProfilerCallback.bigMessage("Profiling... done.");
        long now = System.currentTimeMillis();
        invocations.get(invocations.size() - 1).setEnd(now);
        MethodInvocation last = callstack.pollLast();
        logger.info("Calculating data...");
        last.calc();
        logger.info("Profiling output:\n");
        logger.info(last.dump());
        logger.info("Creating files...");
        new OutputGenerator().renderFromBootstrapTemplate(last);
        new OutputGenerator().renderDebugInfo();
        logger.info("Instrumentation execution... done.");
    }

    public static void before(String objectName, String methodName, int lineNumber) {
        if (!ProfilerCallback.profiling()) {
            return;
        }
        ProfilerCallback.handleInvocation(objectName, methodName, lineNumber);
    }

    public static void after(String objectName, String methodName) {
        if (!ProfilerCallback.profiling()) {
            return;
        }
        long now = System.currentTimeMillis();
        MethodInvocation pollLast = callstack.pollLast();
        pollLast.setEnd(now);
    }

    public static boolean profiling() {
        return callstack.size() > 0;
    }

    public static List<MethodInvocation> getInvocations() {
        return invocations;
    }

    private static void handleInvocation(String objectName, String methodName, int lineNumber) {
        MethodInvocation existingInvocation = ProfilerCallback.getInvocation(callstack.peekLast(), objectName, methodName);
        if (existingInvocation != null) {
            logger.debug("invocation '{}' exists, incrementing count", (Object)existingInvocation);
            existingInvocation.increment();
            callstack.add(existingInvocation);
            return;
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(objectName, methodName, lineNumber);
        MethodInvocation invocation = new MethodInvocation(callstack.peekLast(), methodDescriptor);
        logger.debug("creating new invocation '{}'", (Object)invocation);
        invocations.add(invocation);
        callstack.add(invocation);
    }

    private static MethodInvocation getInvocation(MethodInvocation peekLast, String objectName, String methodName) {
        for (MethodInvocation invocation : invocations) {
            if (invocation.getParent() == null && peekLast != null || !invocation.getParent().equals(peekLast) || !invocation.getCls().equals(objectName) || !invocation.getMethod().equals(methodName)) continue;
            return invocation;
        }
        return null;
    }

    private static void bigMessage(String msg) {
        logger.info("");
        logger.info("=====================");
        logger.info(msg);
        logger.info("=====================");
        logger.info("");
    }
}

