/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.agent;

import de.twenty11.unitprofile.agent.ProfilingClassFileTransformer;
import de.twenty11.unitprofile.domain.MethodDescriptor;
import de.twenty11.unitprofile.domain.Transformation;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingExprEditor
extends ExprEditor {
    private static final Logger logger = LoggerFactory.getLogger(ProfilingExprEditor.class);
    private ProfilingClassFileTransformer classTransformer;
    private CtClass cc;

    public ProfilingExprEditor(ProfilingClassFileTransformer fileTransformer, CtClass cc) {
        this.classTransformer = fileTransformer;
        this.cc = cc;
    }

    public void edit(MethodCall mc) throws CannotCompileException {
        logger.info("MethodCall {}", (Object)(mc.getClassName() + "#" + mc.getMethodName() + "(line " + mc.getLineNumber() + ")"));
        if (this.excluded(mc)) {
            return;
        }
        try {
            this.classTransformer.profile(mc.getMethod(), this.cc);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean excluded(MethodCall mc) {
        if (mc.getClassName().startsWith("java.")) {
            return true;
        }
        if (mc.getClassName().startsWith("de.twenty11.unitprofile.callback.")) {
            return true;
        }
        return mc.getClassName().startsWith("de.twenty11.unitprofile.domain.");
    }

    public void edit(ConstructorCall c) throws CannotCompileException {
        logger.warn("ConstructorCall {}", (Object)(c.getClassName() + "#" + c.getMethodName() + "(line " + c.getLineNumber() + ")"));
        logger.warn("");
    }

    public void edit(FieldAccess f) throws CannotCompileException {
        logger.warn("fieldAccess {}", (Object)f);
    }

    public void edit(Handler h) throws CannotCompileException {
        logger.warn("handler {}", (Object)h);
    }

    public void edit(NewArray newArray) throws CannotCompileException {
        logger.warn("NewArray {} line {}", (Object)newArray.getFileName(), (Object)newArray.getLineNumber());
        try {
            logger.warn("NewArray componentType {}", (Object)newArray.getComponentType());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        logger.warn("NewArray, created dim. {}, dim {}", (Object)newArray.getCreatedDimensions(), (Object)newArray.getDimension());
        logger.warn("");
    }

    public void edit(NewExpr newExpression) throws CannotCompileException {
        logger.warn("NewExpr {} line {}", (Object)newExpression.getFileName(), (Object)newExpression.getLineNumber());
        try {
            CtConstructor constructor = newExpression.getConstructor();
            CtClass ctClass = constructor.getDeclaringClass();
            MethodDescriptor methodDescriptor = new MethodDescriptor(newExpression);
            if (this.classTransformer.isAlreadyInstrumented(methodDescriptor)) {
                return;
            }
            this.classTransformer.addInstrumentation(methodDescriptor);
            if (ctClass.isFrozen()) {
                logger.warn("'{}' is 'frozen'", (Object)ctClass.getName());
                return;
            }
            this.instrument(constructor, ctClass, methodDescriptor);
            Transformation transformation = this.classTransformer.getTransformation(ctClass.getName());
            if (transformation != null) {
                Instrumentation javainstrumentation = this.classTransformer.getInstrumentation();
                ProfilingClassFileTransformer localTransformer = new ProfilingClassFileTransformer(javainstrumentation);
                javainstrumentation.addTransformer(localTransformer, true);
                Class<?> cls1 = Class.forName(ctClass.getName());
                ClassDefinition classDefinition = new ClassDefinition(cls1, ctClass.toBytecode());
                javainstrumentation.redefineClasses(classDefinition);
                javainstrumentation.removeTransformer(localTransformer);
            }
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
    }

    private void instrument(CtConstructor constructor, CtClass ctClass, MethodDescriptor methodDescriptor) throws CannotCompileException {
        constructor.insertBeforeBody(methodDescriptor.getBeforeBody());
        constructor.insertAfter(methodDescriptor.getAfter());
        constructor.instrument((ExprEditor)new ProfilingExprEditor(this.classTransformer, ctClass));
    }
}

