/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofile.agent;

import de.twenty11.unitprofile.agent.ProfilingClassFileTransformer;
import de.twenty11.unitprofile.domain.MethodDescriptor;
import de.twenty11.unitprofile.domain.MethodInvocation;
import java.lang.instrument.Instrumentation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);
    private static ProfilingClassFileTransformer transformer;
    private static MethodInvocation rootInvocation;

    public static void premain(String agentArgs, Instrumentation inst) {
        logger.info("Starting instrumentation for profiling...");
        transformer = new ProfilingClassFileTransformer(inst);
        if (inst.isRetransformClassesSupported()) {
            inst.addTransformer(transformer, true);
        } else {
            logger.warn("Retransformation is not supported be the current JVM...");
            logger.warn("No profiling will be performed by unitprofiler.");
        }
    }

    public static List<MethodDescriptor> getInstrumentations() {
        return transformer.getInstrumentations();
    }

    public static void setRootInvocation(MethodInvocation rootInvocation) {
        Agent.rootInvocation = rootInvocation;
    }

    public static MethodInvocation getRootInvocation() {
        return rootInvocation;
    }
}

