/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.unitprofiler.maven.plugin;

import de.twenty11.unitprofiler.maven.plugin.AbstractUnitProfilerMojo;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public class AgentMojo
extends AbstractUnitProfilerMojo {
    private static final String AGENT_ARTIFACT_NAME = "de.twentyeleven.unitprofiler:unitprofiler.core";
    private static final String SUREFIRE_ARG_LINE = "argLine";
    private Map<String, Artifact> pluginArtifactMap;
    private String propertyName;

    @Override
    public void executeMojo() {
        String formattedString = "-javaagent:" + this.getAgentJarFile().getAbsolutePath();
        this.getLog().info((CharSequence)formattedString);
        String vmArgument = StringUtils.quoteAndEscape((String)formattedString, (char)'\"');
        this.getLog().info((CharSequence)vmArgument);
        this.prependProperty(vmArgument);
    }

    private void prependProperty(String vmArgument) {
        if (this.isPropertyNameSpecified()) {
            this.getLog().info((CharSequence)"propertynamespecified");
            this.prependProperty(this.propertyName, vmArgument);
        } else {
            this.getLog().info((CharSequence)"propertynamespecified  - Else");
            this.prependProperty(SUREFIRE_ARG_LINE, vmArgument);
        }
    }

    private File getAgentJarFile() {
        Artifact unitProfilerAgentJar = this.pluginArtifactMap.get(AGENT_ARTIFACT_NAME);
        return unitProfilerAgentJar.getFile();
    }

    private boolean isPropertyNameSpecified() {
        return this.propertyName != null && !"".equals(this.propertyName);
    }

    private void prependProperty(String name, String value) {
        Properties projectProperties = this.getProject().getProperties();
        String oldValue = projectProperties.getProperty(name);
        String newValue = oldValue == null ? value : value + ' ' + oldValue;
        this.getLog().info((CharSequence)(name + " set to " + newValue));
        projectProperties.put(name, newValue);
    }
}

