/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.integrationtest;

import de.twenty11.skysail.common.osgi.PaxExamOptionSet;
import de.twenty11.skysail.server.integrationtest.SkysailServerOsgiSetup;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class SkysailServerOsgiIT {
    private static Logger logger = LoggerFactory.getLogger((String)SkysailServerOsgiIT.class.getName());
    private List<PaxExamOptionSet> dependencies = new ArrayList<PaxExamOptionSet>();
    @Inject
    private BundleContext context;

    @Configuration
    public Option[] config() {
        this.dependencies.add(PaxExamOptionSet.BASE);
        this.dependencies.add(PaxExamOptionSet.DEBUGGING);
        SkysailServerOsgiSetup setup = new SkysailServerOsgiSetup();
        List<Option> options = setup.getOptions(EnumSet.copyOf(this.dependencies));
        String currentBundleSource = "file:target/skysail.server-" + setup.getProjectVersion() + ".jar";
        logger.info("adding {} to tests...", (Object)currentBundleSource);
        options.add((Option)CoreOptions.bundle((String)currentBundleSource));
        return options.toArray(new Option[options.size()]);
    }

    @Test
    @Ignore
    public void shouldFindCommonBundleInActiveState() {
        Bundle skysailServerBundle = this.getBundleForSymbolicName("skysail.server");
        Assert.assertTrue((skysailServerBundle != null ? 1 : 0) != 0);
        Assert.assertTrue((skysailServerBundle.getState() == 32 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void shouldFindSkysailDatasourceService() {
        Bundle bundle = this.getBundleForSymbolicName("skysail.server");
        ServiceReference skysailDatasourceReference = this.context.getServiceReference("de.twenty11.skysail.server.services.DataSourceProvider");
        Assert.assertTrue((skysailDatasourceReference != null ? 1 : 0) != 0);
    }

    private Bundle getBundleForSymbolicName(String symbolicName) {
        Bundle[] bundles;
        Bundle myBundle = null;
        for (Bundle bundle : bundles = this.context.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            myBundle = bundle;
        }
        return myBundle;
    }
}

