/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.test;

import de.twenty11.skysail.common.grids.ColumnsBuilder;
import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.grids.RowData;
import de.twenty11.skysail.server.restlet.GridDataServerResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.restlet.Request;

public class GridDataServerResourceTest {
    private GridDataServerResource gdsr;

    @Before
    public void setUp() throws Exception {
        ColumnsBuilder builder = new ColumnsBuilder(){

            public void configure() {
                this.addColumn("col0").setWidth(Integer.valueOf(0));
                this.addColumn("col1").sortDesc(Integer.valueOf(1)).setWidth(Integer.valueOf(500));
                this.addColumn("col2").setWidth(Integer.valueOf(240));
                this.addColumn("col3").setWidth(Integer.valueOf(80));
                this.addColumn("col4").sortAsc(null).setWidth(Integer.valueOf(400));
            }
        };
        this.gdsr = new GridDataServerResource(builder){

            public void buildGrid() {
                GridData grid = (GridData)this.getSkysailData();
                this.setDummyData(grid, new String[]{"6", "e", "1.2.3", "ACTIVE"});
                this.setDummyData(grid, new String[]{"5", "d", "10.11.12", "ACTIVE"});
                this.setDummyData(grid, new String[]{"4", "c", "4.5.6", "ACTIVE"});
                this.setDummyData(grid, new String[]{"3", "b", "13.14.15", "ACTIVE"});
                this.setDummyData(grid, new String[]{"2", "a", "7.8.9", "ACTIVE"});
                this.setDummyData(grid, new String[]{"1", "a", "16.17.18", "ACTIVE"});
            }

            private void setDummyData(GridData grid, String[] a) {
                RowData rowData = new RowData(((GridData)this.getSkysailData()).getColumns());
                rowData.add((Object)a[0]).add((Object)a[1]).add((Object)a[2]).add((Object)a[3]);
                grid.addRowData(rowData);
            }
        };
    }

    @Test
    public void testHandlePagination() {
        Assert.assertEquals((long)15L, (long)this.gdsr.handlePagination());
    }

    @Test
    public void testGetData() {
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((long)5L, (long)data.getColumns().getAsList().size());
    }

    @Test
    public void testCurrentPageResults() {
        this.gdsr.getFilteredData();
        GridData currentPageResults = this.gdsr.currentPageResults(2);
        Assert.assertEquals((long)2L, (long)currentPageResults.getRows().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSortSortingParameterTooShort() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/?s=0|0|0|0&pageSize=15&toggleSorting=1");
        this.gdsr.setRequest(request);
        this.gdsr.getFilteredData();
    }

    @Test
    public void testPresorting() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/");
        this.gdsr.setRequest(request);
        int row = 0;
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((Object)"s=0|1|0|0|0&", (Object)data.getSortingRepresentation());
        Assert.assertEquals((long)6L, (long)data.getRows().size());
        Assert.assertEquals((Object)"a", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"a", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"b", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"c", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"d", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"e", (Object)data.getGridElement(row++, 1));
    }

    @Test
    public void testPresortingPlusToggling() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/?toggleSorting=0");
        this.gdsr.setRequest(request);
        int row = 0;
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((Object)"s=2|1|0|0|0&", (Object)data.getSortingRepresentation());
        Assert.assertEquals((long)6L, (long)data.getRows().size());
        Assert.assertEquals((Object)"a", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"a", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"b", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"c", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"d", (Object)data.getGridElement(row++, 1));
        Assert.assertEquals((Object)"e", (Object)data.getGridElement(row++, 1));
    }

    @Test
    public void testSortSymbolicName() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/?s=0|1|0|0|0&pageSize=15");
        this.gdsr.setRequest(request);
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((Object)data.getSortingRepresentation(), (Object)"s=0|1|0|0|0&");
        Assert.assertEquals((long)data.getRows().size(), (long)6L);
        Assert.assertEquals((Object)data.getGridElement(0, 1), (Object)"a");
        Assert.assertEquals((Object)data.getGridElement(1, 1), (Object)"a");
        Assert.assertEquals((Object)data.getGridElement(2, 1), (Object)"b");
    }

    @Test
    public void testToggleSymbolicName() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/?s=1|0|0|0|0&pageSize=15&toggleSorting=1");
        this.gdsr.setRequest(request);
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((Object)"s=1|-2|0|0|0&", (Object)data.getSortingRepresentation());
        Assert.assertEquals((long)6L, (long)data.getRows().size());
        Assert.assertEquals((Object)"e", (Object)data.getGridElement(0, 1));
        Assert.assertEquals((Object)"d", (Object)data.getGridElement(1, 1));
        Assert.assertEquals((Object)"c", (Object)data.getGridElement(2, 1));
        Assert.assertEquals((Object)"6", (Object)data.getGridElement(0, 0));
        Assert.assertEquals((Object)"5", (Object)data.getGridElement(1, 0));
        Assert.assertEquals((Object)"4", (Object)data.getGridElement(2, 0));
    }

    public void testSortId() {
        Request request = new Request();
        request.setResourceRef("http://localhost:8099/rest/osgi/bundles/?s=1|0|0|0|0&pageSize=15");
        this.gdsr.setRequest(request);
        GridData data = this.gdsr.getFilteredData();
        Assert.assertEquals((Object)data.getGridElement(0, 0), (Object)0);
        Assert.assertEquals((Object)data.getGridElement(1, 0), (Object)1);
        Assert.assertEquals((Object)data.getGridElement(2, 0), (Object)5);
    }

    @Test
    public void testSetResponseDetailsSkysailResponseOfGridData() {
    }

    @Test
    public void testGetFilter() {
    }

    @Test
    public void testSetSorting() {
    }

    @Test
    public void testGetPageSize() {
    }

    @Test
    public void testSetPageSize() {
    }

    @Test
    public void testGetCurrentPage() {
    }

    @Test
    public void testSetCurrentPage() {
    }

    @Test
    public void testSetTotalResults() {
    }

    @Test
    public void testGetTotalResults() {
    }
}

