/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.integrationtest;

import de.twenty11.skysail.common.testing.utils.OsgiTestingUtils;
import de.twenty11.skysail.common.testing.utils.PaxExamOptionSet;
import de.twenty11.skysail.server.services.ApplicationProvider;
import de.twenty11.skysail.server.testing.utils.SkysailServerOsgiSetup;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.restlet.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class SkysailServerOsgiIT {
    private static Logger logger = LoggerFactory.getLogger((String)SkysailServerOsgiIT.class.getName());
    private List<PaxExamOptionSet> dependencies = new ArrayList<PaxExamOptionSet>();
    @Inject
    private BundleContext context;

    @Configuration
    public Option[] config() {
        this.dependencies.add(PaxExamOptionSet.BASE);
        this.dependencies.add(PaxExamOptionSet.DEBUGGING);
        SkysailServerOsgiSetup setup = new SkysailServerOsgiSetup();
        List options = setup.getOptions(EnumSet.copyOf(this.dependencies));
        String currentBundleSource = "file:target/skysail.server-" + setup.getProjectVersion() + ".jar";
        logger.info("adding {} to tests...", (Object)currentBundleSource);
        options.add(CoreOptions.bundle((String)currentBundleSource));
        return options.toArray(new Option[options.size()]);
    }

    @Test
    public void shouldFindCommonBundleInActiveState() {
        Bundle skysailServerBundle = OsgiTestingUtils.getBundleForSymbolicName((BundleContext)this.context, (String)"skysail.server");
        Assert.assertTrue((skysailServerBundle != null ? 1 : 0) != 0);
        Assert.assertTrue((skysailServerBundle.getState() == 32 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFindSkysailDatasourceService() {
        Bundle bundle = OsgiTestingUtils.getBundleForSymbolicName((BundleContext)this.context, (String)"skysail.server");
        Assert.assertTrue((bundle != null ? 1 : 0) != 0);
        ServiceReference skysailDatasourceReference = this.context.getServiceReference("de.twenty11.skysail.server.services.DataSourceProvider");
        Assert.assertTrue((skysailDatasourceReference != null ? 1 : 0) != 0);
    }

    @Test
    public void a() {
        ApplicationProvider dummyApplicationProvider = new ApplicationProvider(){

            public Application getApplication() {
                return new Application(){

                    public String getAuthor() {
                        return "author";
                    }
                };
            }
        };
        Assert.assertTrue((dummyApplicationProvider != null ? 1 : 0) != 0);
        this.context.registerService(ApplicationProvider.class.getName(), (Object)dummyApplicationProvider, null);
        ServiceReference serviceReference = this.context.getServiceReference(ApplicationProvider.class.getName());
        ApplicationProvider service = (ApplicationProvider)this.context.getService(serviceReference);
        Application applicationFromService = service.getApplication();
        Assert.assertTrue((boolean)applicationFromService.getAuthor().equals("author"));
    }
}

