/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.um.internal;

import de.twenty11.skysail.common.um.SkysailUser;
import de.twenty11.skysail.server.um.internal.RoleService;
import de.twenty11.skysail.server.um.internal.SkysailRole;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkysailEntityManagerProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityManagerFactory emf;

    protected void activate(ComponentContext component) {
        this.logger.info("activating component in {}", (Object)component.getBundleContext().getBundle().getSymbolicName());
        try {
            EntityManager em = this.emf.createEntityManager();
            this.validateDefaultUser(em);
            em.close();
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SQLIntegrityConstraintViolationException) {
                return;
            }
            e.printStackTrace();
        }
    }

    public void setEntityManager(EntityManagerFactory emf) {
        this.emf = emf;
        RoleService.setEmf(emf);
    }

    private void validateDefaultRole(EntityManager em) {
        em.getTransaction().begin();
        SkysailRole adminrole = new SkysailRole();
        adminrole.setRolename("administrator");
        adminrole.setId(1);
        em.persist((Object)adminrole);
        em.getTransaction().commit();
    }

    private void validateDefaultUser(EntityManager em) {
        em.getTransaction().begin();
        SkysailUser admin = new SkysailUser();
        admin.setLogin("admin");
        admin.setPassword("admin");
        admin.setId(1);
        em.persist((Object)admin);
        em.getTransaction().commit();
    }
}

