/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.um.db;

import com.googlecode.flyway.core.Flyway;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class FlywaySetup {
    private static final String DEFAULT_LOCATIONS = "dbmig/server_um/other";
    private EntityManagerFactory enitityManagerFactory;
    private Flyway flyway = new Flyway();

    public FlywaySetup() {
        this.flyway.setLocations(new String[]{DEFAULT_LOCATIONS});
    }

    public void init() {
        Map properties = (Map)this.enitityManagerFactory.getProperties().get("PUnitInfo");
        BasicDataSource bds = new BasicDataSource();
        if (properties == null) {
            bds.setUrl((String)this.enitityManagerFactory.getProperties().get("javax.persistence.jdbc.url"));
            bds.setPassword((String)this.enitityManagerFactory.getProperties().get("javax.persistence.jdbc.password"));
            bds.setUsername((String)this.enitityManagerFactory.getProperties().get("javax.persistence.jdbc.user"));
            bds.setDriverClassName((String)this.enitityManagerFactory.getProperties().get("javax.persistence.jdbc.driver"));
        } else {
            bds.setUrl((String)properties.get("driverUrl"));
            bds.setPassword((String)properties.get("driverPassword"));
            bds.setUsername((String)properties.get("driverUser"));
            bds.setDriverClassName((String)properties.get("driverClassName"));
        }
        this.flyway.setDataSource((DataSource)bds);
        this.flyway.setTable("skysail_server_um_schema_version");
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(thisClassLoader);
        this.flyway.setInitOnMigrate(true);
        this.flyway.migrate();
        Thread.currentThread().setContextClassLoader(ccl);
    }

    public synchronized void setEntityManager(EntityManagerFactory emf) {
        this.enitityManagerFactory = emf;
    }

    public void setLocation(String locations) {
        this.flyway.setLocations(new String[]{locations});
    }
}

